(function (ng) {
    'use strict';

    function valOutput(style) {
        return typeof style === 'object' ? (style.value || 0) + (style.unit || 'px') : (style || 0) + "px";
    }

    function checkForPrivate(el, ifPrivate, ifNotPrivate) {
        return (el.isPrivate && typeof el[ifPrivate] !== "undefined") ? el[ifPrivate] : el[ifNotPrivate];
    }

    var app = ng.module("ufApp.directives.FormElements", []);
    app.directive('ufElementProxy', ['$parse', '$injector', '$compile', '$window', function ($parse, $injector, $compile, $window) {
        return {
            replace: true,
            scope: {
                activeFormStyles: "=",
                defaultStyles: "=",
                el: "=ngModel",
                elementActions: "="
            },
            template: '<div id="{{el.id}}" class="element-wrap clearfix" ng-style="fRowStyle()" ng-click="elementActions.setActive($event, el)">' +
            '<div ng-if="forFieldsOnly()" ng-style="btnsOffset()" class="bs-wrapper element-action-btns"><div class="btn-group" role="group">' +
            '<button type="button" class="btn btn-default" ng-hide="noCopy" ng-click="elementActions.copy($event, el)" title="Copy field"><i class="fa fa-copy"></i></button>' +
            '<button type="button" class="btn btn-default" ng-click="elementActions.remove($event, el)" title="Remove field"><i class="fa fa-trash"></i></button>' +
            '</div></div></div>',
            link: function (scope, element, attrs) {
                var includeElementName = attrs.ufElementProxy;
                var x = ng.element('<div class="uf-field-wrapper clearfix" ng-class="fieldWrapClass()" ' + includeElementName + '-element></div>');
                element.append(x);
                $compile(x)(scope);

                scope.noCopy = ["captcha"].indexOf(scope.el.type) > -1;

                var elementsActiveCss = {
                    title: ["color", "fontSize", "border", "borderRadius", "boxShadow", "textShadow", "width",
                        "padding", "margin", "backgroundImage", "background", "backgroundSize", "backgroundRepeat",
                        "backgroundPosition", "backgroundColor", "textAlign"],
                    paragraph: ["color", "fontSize", "border", "borderRadius", "boxShadow", "textShadow", "width",
                        "padding", "margin", "backgroundImage", "background", "backgroundSize", "backgroundRepeat",
                        "backgroundPosition", "backgroundColor", "textAlign"],
                    select: ["color", "fontSize", "border", "borderRadius", "boxShadow", "width", "padding",
                        "backgroundImage", "background", "backgroundSize", "backgroundRepeat", "backgroundPosition",
                        "backgroundColor", "fontStyle", "textDecoration", "fontWeight"],
                    checkbox: ["color", "fontSize"],
                    radio: [],
                    captcha: [],
                    text: [],
                    textarea: ["color", "fontSize", "border", "borderRadius", "boxShadow", "width", "height", "padding",
                        "backgroundImage", "background", "backgroundSize", "backgroundRepeat", "backgroundPosition",
                        "backgroundColor", "fontStyle", "textDecoration", "fontWeight"]
                };
                scope.fieldWrapClass = function () {
                    var classes = [];
                    if (typeof scope.activeFormStyles !== "undefined")
                        classes.push(scope.activeFormStyles.labelAlign === 'left' ? "label-location-left" : "label-location-top");
                    return classes;
                }
                scope.fRowStyle = function () {
                    if (!scope.forFieldsOnly() || !scope.activeFormStyles) return {};
                    return {
                        'paddingBottom': valOutput(scope.activeFormStyles.formLineHeight)
                    }
                };
                scope.forFieldsOnly = function () {
                    return scope.el && ["button", "errmess", "succmess", "loadmess"].indexOf(scope.el.type) === -1;
                };

                scope.labelStyle = function () {
                    var settings = ng.extend({}, scope.activeFormStyles, scope.el);
                    var styles = {};
                    if (settings.labelAlign === 'in') {
                        styles = {
                            display: "none"
                        };
                    } else {
                        styles = {
                            marginBottom: valOutput(settings.labelMargin),
                            marginRight: 0,
                            color: settings.isPrivate === "true" ? settings.labelFieldColor : scope.activeFormStyles.labelFieldColor,
                            fontSize: valOutput(settings.isPrivate === "true" ? settings.labelFontSize : scope.activeFormStyles.labelFontSize),
                            width: valOutput(settings.labelWidth),
                            fontWeight: settings.labelFontStyle.bold === "true" ? "bold" : null,
                            fontStyle: settings.labelFontStyle.italic === "true" ? "italic" : null,
                            textDecoration: settings.labelFontStyle.underline === "true" ? "underline" : null,

                        };
                    }
                    return styles;
                };


                scope.elementStyle = function () {
                    if (!scope.el) return;
                    var s = ng.copy(scope.el);
                    var defaultElValues = scope.defaultStyles;
                    Object.keys(defaultElValues[scope.el.type]).forEach(function (key) {
                        if (!key in s) {
                            s[key] = defaultElValues[scope.el.type][key];
                        }
                    });

                    Object.keys(scope.activeFormStyles).forEach(function (key) {
                        s[key] = scope.activeFormStyles[key];
                    });

                    var styles = {
                        color: (checkForPrivate(s, 'color', 'fieldTextColor')),
                        fontSize: valOutput(checkForPrivate(s, 'fontSize', 'fieldFontSize')),
                        //fontWeight: (s.fontWeight),
                        textAlign: (s.textAlign),
                        float: (s.float),
                        textShadow: s.textShadowHorz > 0 || s.textShadowVert > 0 || s.textShadowBlur > 0 ? [
                            valOutput(s.textShadowHorz),
                            valOutput(s.textShadowVert),
                            valOutput(s.textShadowBlur),
                            (s.textShadowColor)
                        ].join(" ") : null,
                        boxShadow: [
                            (checkForPrivate(s, 'shadowInset', 'fieldBoxShadowInset') === "true" ? "inset" : ""),
                            (checkForPrivate(s, 'shadowColor', 'fieldBoxShadowColor')),
                            valOutput(checkForPrivate(s, 'shadowHorz', 'fieldBoxShadowH')),
                            valOutput(checkForPrivate(s, 'shadowVert', 'fieldBoxShadowV')),
                            valOutput(checkForPrivate(s, 'shadowBlur', 'fieldBoxShadowBlur'))
                        ].join(" "),
                        width: valOutput(checkForPrivate(s, 'width', (s.type === "textarea" ? 'fieldAreaWidth' : 'fieldWidth'))),
                        height: valOutput(s.fieldAreaHeight),
                        border: [
                            valOutput(checkForPrivate(s, 'borderSize', 'fieldBorderSize')),
                            (checkForPrivate(s, 'borderStyle', 'fieldBorderType')),
                            (checkForPrivate(s, 'borderColor', 'fieldBorderColor'))
                        ].join(" "),
                        padding: [
                            valOutput(checkForPrivate(s, 'paddingTop', 'fieldPaddingTop')),
                            valOutput(checkForPrivate(s, 'paddingRight', 'fieldPaddingRight')),
                            valOutput(checkForPrivate(s, 'paddingBottom', 'fieldPaddingBottom')),
                            valOutput(checkForPrivate(s, 'paddingLeft', 'fieldPaddingLeft'))
                        ].join(" "),
                        margin: [
                            valOutput(s.marginTop),
                            valOutput(s.marginRight),
                            valOutput(s.marginBottom),
                            valOutput(s.marginLeft)
                        ].join(" "),
                        fontWeight: s.fieldFontStyle.bold === "true" ? "bold" : null,
                        fontStyle: s.fieldFontStyle.italic === "true" ? "italic" : null,
                        textDecoration: s.fieldFontStyle.underline === "true" ? "underline" : null,
                        borderRadius: valOutput(checkForPrivate(s, 'borderRadius', 'fieldBorderRadius'))
                    };
                    if (checkForPrivate(s, 'bgType', 'fieldBgType') === "solid") {
                        styles.background = checkForPrivate(s, 'bgStartColor', 'fieldBgStartColor');
                    } else if (checkForPrivate(s, 'bgType', 'fieldBgType') === "gradient") {
                        styles.backgroundImage =
                            "linear-gradient(" +
                            checkForPrivate(s, 'bgStartColor', 'fieldBgStartColor') + ", " +
                            checkForPrivate(s, 'bgEndColor', 'fieldBgEndColor') +
                            ")";
                    } else if (checkForPrivate(s, 'bgType', 'fieldBgType') === "img") {
                        styles.backgroundColor = checkForPrivate(s, 'bgStartColor', 'fieldBgStartColor');
                        styles.backgroundImage = "url(" + $window.g_urlRoot + checkForPrivate(s, 'bgImg', 'fieldBgImg') + ")";
                        styles.backgroundSize = checkForPrivate(s, 'bgFit', 'fieldBgFit');
                        styles.backgroundRepeat = checkForPrivate(s, 'bgRepeat', 'fieldBgRepeat');
                        styles.backgroundPosition = checkForPrivate(s, 'bgPosition', 'fieldBgPosition');
                    }
                    Object.keys(styles).forEach(function (key) {
                        if (elementsActiveCss[scope.el.type].indexOf(key) === -1) {
                            delete styles[key];
                        }
                    });
                    return styles;
                };

                var formPreviewEl = ng.element("#uf-form-settings-preview");

                formPreviewEl.on("scroll", function () {
                    scope.$digest();
                });

                scope.btnsOffset = function () {
                    if (scope.activeFormStyles.formDirection === 'rtl') {
                        return {left: 0};
                    } else {
                        var rightPos = element[0].offsetLeft + element.width() - formPreviewEl.width() - formPreviewEl[0].scrollLeft + 2;
                        return {right: (rightPos > 0 ? rightPos : 0) + "px"}
                    }
                }
            }
        }
    }
    ]);

    app.directive("textElement", function ($window) {
        return {
            restrict: "AE",
            require: "^ngModel",
            template: '<div class="ko-lbl uf-field-label" ng-style="labelStyle(el)">' +
            '<span ng-bind="el.label"></span>' +
            '<span ng-show="el.required === \'true\'" class="uf-alrt"> *</span></div>' +
            '<label class="textbox-wrap" ce-resize="e" ng-style="textContainerStyle()">' +
            '   <input ng-focus="focusedInput()" ng-blur="bluredInput()" class="ko-fld uf-field-text" type="text" ng-model="el.value" ng-style="textElementStyle()"/>' +
            '   <span class="inp-placeholder" ng-style="placeholderStyle()" ng-show="showPlaceholder && !focused && !hasValue" ng-bind="el.label"></span>' +
            '</label>',
            link: function (scope) {
                scope.showPlaceholder = false;
                scope.focused = false;
                scope.focusedInput = function () {
                    scope.focused = true;
                };
                scope.bluredInput = function () {
                    scope.focused = false;
                };
                scope.$watch("el.value", function (value) {
                    scope.hasValue = value.length > 0;
                });
                scope.$watch("activeFormStyles.labelAlign", function (labelAlign) {
                    scope.showPlaceholder = labelAlign === "in";
                });
                scope.textElementStyle = function () {
                    if (!scope.el) return;
                    var s = ng.copy(scope.el);
                    var defaultElValues = scope.defaultStyles;
                    Object.keys(defaultElValues[scope.el.type]).forEach(function (key) {
                        if (!key in s) {
                            s[key] = defaultElValues[scope.el.type][key];
                        }
                    });

                    Object.keys(scope.activeFormStyles).forEach(function (key) {
                        s[key] = scope.activeFormStyles[key];
                    });

                    var styles = {
                        color: (checkForPrivate(s, 'color', 'fieldTextColor')),
                        fontSize: valOutput(checkForPrivate(s, 'fontSize', 'fieldFontSize')),
                        boxShadow: [
                            (checkForPrivate(s, 'shadowInset', 'fieldBoxShadowInset') === "true" ? "inset" : ""),
                            (checkForPrivate(s, 'shadowColor', 'fieldBoxShadowColor')),
                            valOutput(checkForPrivate(s, 'shadowHorz', 'fieldBoxShadowH')),
                            valOutput(checkForPrivate(s, 'shadowVert', 'fieldBoxShadowV')),
                            valOutput(checkForPrivate(s, 'shadowBlur', 'fieldBoxShadowBlur'))
                        ].join(" "),
                        border: [
                            valOutput(checkForPrivate(s, 'borderSize', 'fieldBorderSize')),
                            (checkForPrivate(s, 'borderStyle', 'fieldBorderType')),
                            (checkForPrivate(s, 'borderColor', 'fieldBorderColor'))
                        ].join(" "),
                        padding: [
                            valOutput(checkForPrivate(s, 'paddingTop', 'fieldPaddingTop')),
                            valOutput(checkForPrivate(s, 'paddingRight', 'fieldPaddingRight')),
                            valOutput(checkForPrivate(s, 'paddingBottom', 'fieldPaddingBottom')),
                            valOutput(checkForPrivate(s, 'paddingLeft', 'fieldPaddingLeft'))
                        ].join(" "),
                        borderRadius: valOutput(checkForPrivate(s, 'borderRadius', 'fieldBorderRadius')),
                        fontWeight: s.fieldFontStyle.bold === "true" ? "bold" : null,
                        fontStyle: s.fieldFontStyle.italic === "true" ? "italic" : null,
                        textDecoration: s.fieldFontStyle.underline === "true" ? "underline" : null
                    };
                    if (checkForPrivate(s, 'bgType', 'fieldBgType') === "solid") {
                        styles.background = checkForPrivate(s, 'bgStartColor', 'fieldBgStartColor');
                    } else if (checkForPrivate(s, 'bgType', 'fieldBgType') === "gradient") {
                        styles.backgroundImage =
                            "linear-gradient(" +
                            checkForPrivate(s, 'bgStartColor', 'fieldBgStartColor') + ", " +
                            checkForPrivate(s, 'bgEndColor', 'fieldBgEndColor') +
                            ")";
                    } else if (checkForPrivate(s, 'bgType', 'fieldBgType') === "img") {
                        styles.backgroundColor = checkForPrivate(s, 'bgStartColor', 'fieldBgStartColor');
                        styles.backgroundImage = "url(" + $window.g_urlRoot + checkForPrivate(s, 'bgImg', 'fieldBgImg') + ")";
                        styles.backgroundSize = checkForPrivate(s, 'bgFit', 'fieldBgFit');
                        styles.backgroundRepeat = checkForPrivate(s, 'bgRepeat', 'fieldBgRepeat');
                        styles.backgroundPosition = checkForPrivate(s, 'bgPosition', 'fieldBgPosition');
                    }
                    return styles;
                };
                scope.textContainerStyle = function () {
                    if (!scope.el) return;
                    var s = ng.copy(scope.el);
                    var defaultElValues = scope.defaultStyles;
                    Object.keys(defaultElValues[scope.el.type]).forEach(function (key) {
                        if (!key in s) {
                            s[key] = defaultElValues[scope.el.type][key];
                        }
                    });
                    Object.keys(scope.activeFormStyles).forEach(function (key) {
                        s[key] = scope.activeFormStyles[key];
                    });
                    var styles = {
                        width: valOutput(checkForPrivate(s, 'width', 'fieldWidth')),
                    }
                    return styles;
                }

                scope.placeholderStyle = function () {
                    var styles = {
                        color: scope.activeFormStyles.labelFieldColor,
                        fontSize: valOutput(scope.activeFormStyles.labelFontSize),
                        width: valOutput(scope.activeFormStyles.labelWidth)
                    }
                    if (scope.activeFormStyles.formDirection === "ltr") {
                        styles.left = 0;
                        styles.marginLeft = valOutput(scope.activeFormStyles.labelMargin);
                    } else {
                        styles.right = 0;
                        styles.marginRight = valOutput(scope.activeFormStyles.labelMargin);
                    }

                    return styles;
                }
            }
        }
    });

    app.directive("rowElement", function () {
        return {
            restrict: "AE",
            require: "^ngModel",
            template: '<div ng-repeat="field in el.fields"><div uf-element-proxy="field.type" ng-model="field"></div></div>'
        }
    });

    app.directive("buttonElement", function ($window) {
        return {
            restrict: "AE",
            require: "^ngModel",
            template: '<button type="button" name="sendFormButton" ng-style="styles()" ng-bind="el.value" class="field-details"></button>',
            link: function (scope) {
                scope.styles = function () {
                    var s = scope.activeFormStyles;
                    var styles = {
                        color: s.buttonColor,
                        fontSize: valOutput(s.buttonFontSize),
                        fontWeight: s.buttonFontStyle.bold === "true" ? "bold" : null,
                        fontStyle: s.buttonFontStyle.italic === "true" ? "italic" : null,
                        textDecoration: s.buttonFontStyle.underline === "true" ? "underline" : null,
                        border: [
                            valOutput(s.buttonBorderSize),
                            s.buttonBorderType,
                            s.buttonBorderColor
                        ].join(" "),
                        borderRadius: valOutput(s.buttonBorderRadius),
                        textShadow: s.buttonTextShadowH > 0 || s.buttonTextShadowV > 0 || s.buttonTextShadowBlur > 0 ? [
                            valOutput(s.buttonTextShadowH),
                            valOutput(s.buttonTextShadowV),
                            valOutput(s.buttonTextShadowBlur),
                            s.buttonTextShadowColor
                        ].join(" ") : null,
                        boxShadow: [
                            (s.buttonBoxShadowInset === "true" ? "inset" : ""),
                            s.buttonBoxShadowColor,
                            valOutput(s.buttonBoxShadowH),
                            valOutput(s.buttonBoxShadowV),
                            valOutput(s.buttonBoxShadowBlur)
                        ].join(" "),
                        padding: [
                            valOutput(s.buttonPaddingTop),
                            valOutput(s.buttonPaddingRight),
                            valOutput(s.buttonPaddingBottom),
                            valOutput(s.buttonPaddingLeft)
                        ].join(" "),
                        marginTop: valOutput(s.buttonMarginTop),
                        marginBottom: valOutput(s.buttonMarginBottom),
                        float: s.buttonFloat
                    }

                    if (s.formDirection === 'rtl') {
                        styles.marginRight = valOutput(s.buttonMarginSide)
                    } else {
                        styles.marginLeft = valOutput(s.buttonMarginSide)
                    }

                    if (s.buttonBackgroundType === "solid") {
                        styles.background = s.buttonBackgroundColor;
                    } else if (s.buttonBackgroundType === "gradient") {
                        styles.backgroundImage =
                            "linear-gradient(" +
                            (s.buttonBackgroundStartColor) + ", " +
                            (s.buttonBackgroundEndColor) +
                            ")";
                    } else if (s.buttonBackgroundType === "img") {
                        styles.backgroundColor = s.buttonBackgroundColor;
                        styles.backgroundImage = "url(" + $window.g_urlRoot + s.buttonBackgroundImg + ")";
                        styles.backgroundSize = s.buttonBackgroundFit;
                        styles.backgroundRepeat = s.buttonBackgroundRepeat;
                        styles.backgroundPosition = s.buttonBackgroundPosition;
                    }
                    return styles;
                }
            }
        }
    });

    app.directive("textareaElement", function () {
        return {
            restrict: "AE",
            require: "^ngModel",
            template: '<div class="ko-lbl uf-field-label" ng-style="labelStyle()">' +
            '<span ng-bind="el.label"></span>' +
            '<span ng-show="el.required === \'true\'" class="uf-alrt"> *</span></div>' +
            '<label class="textbox-wrap">' +
            '   <textarea ng-focus="focusedInput()" ng-blur="bluredInput()" ng-model="el.value" class="ko-fld uf-field-textarea" ng-style="elementStyle()"></textarea>' +
            '   <span class="inp-placeholder" ng-style="placeholderStyle()" ng-show="showPlaceholder && !focused && !hasValue" ng-bind="el.label"></span>' +
            '</label>',
            link: function (scope) {
                scope.showPlaceholder = false;
                scope.focused = false;
                scope.focusedInput = function () {
                    scope.focused = true;
                };
                scope.bluredInput = function () {
                    scope.focused = false;
                };
                scope.$watch("el.value", function (value) {
                    scope.hasValue = value.length > 0;
                });
                scope.$watch("activeFormStyles.labelAlign", function (labelAlign) {
                    scope.showPlaceholder = labelAlign === "in";
                });
                scope.placeholderStyle = function () {
                    var styles = {
                        color: scope.activeFormStyles.labelFieldColor,
                        fontSize: valOutput(scope.activeFormStyles.labelFontSize),
                        width: valOutput(scope.activeFormStyles.labelWidth),
                        marginTop: valOutput(scope.activeFormStyles.labelMargin)
                    }
                    if (scope.activeFormStyles.formDirection === "ltr") {
                        styles.left = 0;
                        styles.marginLeft = valOutput(scope.activeFormStyles.labelMargin);
                    } else {
                        styles.right = 0;
                        styles.marginRight = valOutput(scope.activeFormStyles.labelMargin);
                    }

                    return styles;
                }
            }
        }
    });

    app.directive("checkboxElement", function () {
        return {
            restrict: "AE",
            require: "^ngModel",
            template: '<div class="ko-lbl uf-field-label" ng-style="labelStyle()">' +
            '<span ng-bind="el.label"></span>' +
            '<span ng-show="el.required === \'true\'" class="uf-alrt"> *</span></div>' +
            '<ul class="ko-lst" ng-style="elementStyle()"><li ng-repeat="opt in el.options">' +
            '<label><input ng-value="opt.value" type="checkbox" ng-checked="opt.checked" ng-click="setChecked(opt)" name="{{\'checkbox\' + el.id}}" class="uf-checkbox-item"/>' +
            '<span ng-bind="opt.label" class="uf-fielditem-label uf-checkbox-label" ng-style="optionLabelStyles()"></span></label></li></ul>',
            link: function (scope) {
                scope.setChecked = function (opt) {
                    opt.checked = !opt.checked;
                };
                scope.optionLabelStyles = function () {
                    return {
                        color: valOutput(scope.el.isPrivate === "true" ? scope.el.fieldTextColor : scope.activeFormStyles.fieldTextColor),
                        fontSize: valOutput(scope.el.isPrivate === "true" ? scope.el.fieldFontSize : scope.activeFormStyles.fieldFontSize)
                    }
                }
            }
        }
    });

    app.directive("radioElement", function () {
        return {
            restrict: "AE",
            require: "^ngModel",
            template: '<div class="ko-lbl uf-field-label" ng-style="labelStyle()">' +
            '<span ng-bind="el.label"></span>' +
            '<span ng-show="el.required === \'true\'" class="uf-alrt"> *</span></div>' +
            '<ul class="ko-lst" ng-style="elementStyle()"><li ng-repeat="opt in el.options">' +
            '<label><input ng-value="opt.value" type="radio" ng-checked="opt.checked" ng-click="setChecked(opt)" name="{{\'radio\' + el.id}}" class="uf-radio-item"/>' +
            '<span ng-bind="opt.label" class="uf-fielditem-label uf-radio-label" ng-style="optionLabelStyles()"></span></label></li></ul>',
            link: function (scope) {
                scope.setChecked = function (opt) {
                    scope.el.options.forEach(function (o) {
                        o.checked = false;
                    });
                    opt.checked = true;
                };
                scope.optionLabelStyles = function () {
                    return {
                        color: valOutput(scope.el.isPrivate === "true" ? scope.el.fieldTextColor : scope.activeFormStyles.fieldTextColor),
                        fontSize: valOutput(scope.el.isPrivate === "true" ? scope.el.fieldFontSize : scope.activeFormStyles.fieldFontSize)
                    }
                }
            }
        }
    });

    app.directive("selectElement", function () {
        return {
            restrict: "AE",
            require: "^ngModel",
            template: '<div class="ko-lbl uf-field-label" ng-style="labelStyle(el)">' +
            '<span ng-bind="el.label"></span>' +
            '<span ng-show="el.required === \'true\'" class="uf-alrt"> *</span></div>' +
            '<select class="ko-fld" ng-style="elementStyle(el)">' +
            '<option ng-repeat="o in el.options" ng-value="o.value" ng-selected="o.checked" ng-bind="o.label"></option>' +
            '</select>'
        }
    });

    app.directive("titleElement", function ($window) {
        return {
            restrict: "AE",
            require: "^ngModel",
            template: '<h3 class="ko-lbl" ng-style="styles()" ng-bind="el.label"></h3>',
            link: function (scope) {
                scope.styles = function () {
                    var s = scope.activeFormStyles;
                    var styles = {
                        color: s.titleColor,
                        fontSize: valOutput(s.titleFontSize),
                        fontWeight: s.titleFontStyle.bold === "true" ? "bold" : null,
                        fontStyle: s.titleFontStyle.italic === "true" ? "italic" : null,
                        textDecoration: s.titleFontStyle.underline === "true" ? "underline" : null,
                        border: [
                            valOutput(s.titleBorderSize),
                            s.titleBorderType,
                            s.titleBorderColor
                        ].join(" "),
                        borderRadius: valOutput(s.titleBorderRadius),
                        textShadow: s.titleTextShadowH > 0 || s.titleTextShadowV > 0 || s.titleTextShadowBlur > 0 ? [
                            valOutput(s.titleTextShadowH),
                            valOutput(s.titleTextShadowV),
                            valOutput(s.titleTextShadowBlur),
                            s.titleTextShadowColor
                        ].join(" ") : null,
                        boxShadow: [
                            (s.titleBoxShadowInset === "true" ? "inset" : ""),
                            s.titleBoxShadowColor,
                            valOutput(s.titleBoxShadowH),
                            valOutput(s.titleBoxShadowV),
                            valOutput(s.titleBoxShadowBlur)
                        ].join(" "),
                        width: valOutput(s.titleWidth),
                        padding: [
                            valOutput(s.titlePaddingTop),
                            valOutput(s.titlePaddingRight),
                            valOutput(s.titlePaddingBottom),
                            valOutput(s.titlePaddingLeft)
                        ].join(" "),
                        margin: [
                            valOutput(s.titleMarginTop),
                            valOutput(s.titleMarginRight),
                            valOutput(s.titleMarginBottom),
                            valOutput(s.titleMarginLeft)
                        ].join(" "),
                        textAlign: s.titleAlign,
                        whiteSpace: "pre"
                    }

                    if (s.titleBackgroundType === "solid") {
                        styles.background = s.titleBackgroundColor;
                    } else if (s.titleBackgroundType === "gradient") {
                        styles.backgroundImage =
                            "linear-gradient(" +
                            (s.titleBackgroundStartColor) + ", " +
                            (s.titleBackgroundEndColor) +
                            ")";
                    } else if (s.titleBackgroundType === "img") {
                        styles.backgroundColor = s.titleBackgroundColor;
                        styles.backgroundImage = "url(" + $window.g_urlRoot + s.titleBackgroundImg + ")";
                        styles.backgroundSize = s.titleBackgroundFit;
                        styles.backgroundRepeat = s.titleBackgroundRepeat;
                        styles.backgroundPosition = s.titleBackgroundPosition;
                    }
                    return styles;
                }
            }
        }
    });

    app.directive("paragraphElement", function ($window) {
        return {
            restrict: "AE",
            require: "^ngModel",
            template: '<div class="ko-lbl" ng-style="styles()" ng-bind-html="el.label"></div>',
            link: function (scope) {
                scope.styles = function () {
                    var s = scope.activeFormStyles;
                    var styles = {
                        color: s.descriptionColor,
                        fontSize: valOutput(s.descriptionFontSize),
                        fontWeight: s.descriptionFontStyle.bold === "true" ? "bold" : null,
                        fontStyle: s.descriptionFontStyle.italic === "true" ? "italic" : null,
                        textDecoration: s.descriptionFontStyle.underline === "true" ? "underline" : null,
                        border: [
                            valOutput(s.descriptionBorderSize),
                            s.descriptionBorderType,
                            s.descriptionBorderColor
                        ].join(" "),
                        borderRadius: valOutput(s.descriptionBorderRadius),
                        textShadow: s.descriptionTextShadowH > 0 || s.descriptionTextShadowV > 0 || s.descriptionTextShadowBlur > 0 ? [
                            valOutput(s.descriptionTextShadowH),
                            valOutput(s.descriptionTextShadowV),
                            valOutput(s.descriptionTextShadowBlur),
                            s.descriptionTextShadowColor
                        ].join(" ") : null,
                        boxShadow: [
                            (s.descriptionBoxShadowInset === "true" ? "inset" : ""),
                            s.descriptionBoxShadowColor,
                            valOutput(s.descriptionBoxShadowH),
                            valOutput(s.descriptionBoxShadowV),
                            valOutput(s.descriptionBoxShadowBlur)
                        ].join(" "),
                        width: valOutput(s.descriptionWidth),
                        padding: [
                            valOutput(s.descriptionPaddingTop),
                            valOutput(s.descriptionPaddingRight),
                            valOutput(s.descriptionPaddingBottom),
                            valOutput(s.descriptionPaddingLeft)
                        ].join(" "),
                        margin: [
                            valOutput(s.descriptionMarginTop),
                            valOutput(s.descriptionMarginRight),
                            valOutput(s.descriptionMarginBottom),
                            valOutput(s.descriptionMarginLeft)
                        ].join(" "),
                        textAlign: s.descriptionAlign,
                        whiteSpace: "pre"
                    }

                    if (s.descriptionBackgroundType === "solid") {
                        styles.background = s.descriptionBackgroundColor;
                    } else if (s.descriptionBackgroundType === "gradient") {
                        styles.backgroundImage =
                            "linear-gradient(" +
                            (s.descriptionBackgroundStartColor) + ", " +
                            (s.descriptionBackgroundEndColor) +
                            ")";
                    } else if (s.descriptionBackgroundType === "img") {
                        styles.backgroundColor = s.descriptionBackgroundColor;
                        styles.backgroundImage = "url(" + $window.g_urlRoot + s.descriptionBackgroundImg + ")";
                        styles.backgroundSize = s.descriptionBackgroundFit;
                        styles.backgroundRepeat = s.descriptionBackgroundRepeat;
                        styles.backgroundPosition = s.descriptionBackgroundPosition;
                    }
                    return styles;
                }
            }
        }
    });

    app.directive("messageElement", function ($window) {
        return {
            restrict: "AE",
            require: "^ngModel",
            template: '<div class="ko-lbl uf-{{type}}-message" ng-style="styles()" ng-bind="el.label"></div>',
            link: function (scope) {
                switch (scope.el.type) {
                    case "succmess":
                        scope.type = "confirm";
                        break;
                    case "errmess":
                        scope.type = "error";
                        break;
                    case "loadmess":
                        scope.type = "sending";
                        break;
                }
                scope.styles = function () {
                    var s = scope.el;
                    var styles = {
                        color: s.color,
                        fontSize: valOutput(s.fontSize),
                        border: [
                            valOutput(s.borderWidth),
                            s.borderType,
                            s.borderColor
                        ].join(" "),
                        borderRadius: valOutput(s.borderRadius),
                        textShadow: s.shadowH > 0 || s.shadowV > 0 || s.shadowBlur > 0 ? [
                            valOutput(s.shadowH),
                            valOutput(s.shadowV),
                            valOutput(s.shadowBlur),
                            s.shadowColor
                        ].join(" ") : null,
                        boxShadow: [
                            (s.boxShadowInset === "true" ? "inset" : ""),
                            s.boxShadowColor,
                            valOutput(s.boxShadowH),
                            valOutput(s.boxShadowV),
                            valOutput(s.boxShadowB)
                        ].join(" "),
                        width: valOutput(s.width),
                        padding: [
                            valOutput(s.paddingTop),
                            valOutput(s.paddingRight),
                            valOutput(s.paddingBottom),
                            valOutput(s.paddingLeft)
                        ].join(" "),
                        margin: [
                            valOutput(s.marginTop),
                            valOutput(s.marginRight),
                            valOutput(s.marginBottom),
                            valOutput(s.marginLeft)
                        ].join(" "),
                        textAlign: s.textAlign
                    }

                    if (s.bgType === "solid") {
                        styles.background = s.bgStartColor;
                    } else if (s.bgType === "gradient") {
                        styles.backgroundImage =
                            "linear-gradient(" +
                            (s.bgStartColor) + ", " +
                            (s.bgEndColor) +
                            ")";
                    } else if (s.bgType === "img") {
                        styles.backgroundColor = s.bgStartColor;
                        styles.backgroundImage = "url(" + $window.g_urlRoot + s.bgImg + ")";
                        styles.backgroundSize = s.bgFit;
                        styles.backgroundRepeat = s.bgRepeat;
                        styles.backgroundPosition = s.bgPosition;
                    }
                    return styles;
                }
            }
        }
    });

    app.directive("captchaElement", function ($window) {
        var assetsPath = $window.g_urlAssets;
        return {
            restrict: "AE",
            require: "^ngModel",
            template: '<div class="uf-captcha clearfix" ng-style="captchaWrapStyles()">' +
            '<div ng-style="innerStyles()" class="uf-captcha-inner">' +
            '<img ng-style="imgStyles()" alt="captcha" ng-src="{{\'' + assetsPath + '/captchas/captcha.jpg\'}}">' +
            '<div class="uf-captcha-input-wrapper"><div ng-bind="el.label" class="ko-lbl" ng-style="captchaLabelStyle()"></div>' +
            '<input class="uf-field input-block-level" type="text" ng-style="inputStyles()" placeholder="{{el.placeholder}}"/></div>' +
            '</div></div>',
            link: function (scope) {
                scope.captchaLabelStyle = function () {
                    var styles = scope.labelStyle();
                    styles.marginTop = styles.marginBottom;
                    return styles;
                }

                scope.captchaWrapStyles = function () {
                    var s = ng.copy(scope.el),
                        styles = {};

                    switch(s.align){
                        case "center": styles.margin = "0 auto"; break;
                        case "left": styles.margin = "0 auto 0 0"; break;
                        case "right": styles.margin = "0 0 0 auto"; break;
                    };

                    return styles;
                }
                scope.innerStyles = function () {
                    var s = ng.copy(scope.el);
                    return {
                        border: [
                            valOutput(s.borderWidth),
                            s.borderType,
                            s.borderColor
                        ].join(" "),
                        borderRadius: valOutput(s.borderRadius)
                    }
                }
                scope.imgStyles = function () {
                    var s = ng.copy(scope.el);
                    return {
                        width: valOutput(s.width),
                        height: valOutput(s.height)
                    }
                }
                scope.inputStyles = function () {
                    var s = ng.copy(scope.el);
                    Object.keys(scope.activeFormStyles).forEach(function (key) {
                        s[key] = scope.activeFormStyles[key];
                    });
                    return {
                        border: [
                            valOutput(s.fieldBorderSize),
                            (s.fieldBorderType),
                            (s.fieldBorderColor)
                        ].join(" "),
                        padding: [
                            valOutput(s.fieldPaddingTop),
                            valOutput(s.fieldPaddingRight),
                            valOutput(s.fieldPaddingBottom),
                            valOutput(s.fieldPaddingLeft)
                        ].join(" "),
                        color: (s.fieldTextColor),
                        fontSize: valOutput(s.fieldFontSize),
                        boxShadow: [
                            (s.fieldBoxShadowInset === "true" ? "inset" : ""),
                            (s.fieldBoxShadowColor),
                            valOutput(s.fieldBoxShadowH),
                            valOutput(s.fieldBoxShadowV),
                            valOutput(s.fieldBoxShadowBlur)
                        ].join(" "),
                        borderRadius: valOutput(s.fieldBorderRadius),
                        width: valOutput(s.width)
                    }
                }

            }
        }
    });

    app.directive("imageElement", function ($window) {
        var assetsPath = $window.g_urlRoot;
        return {
            restrict: "AE",
            require: "^ngModel",
            template: '<div class="uf-image-element clearfix">' +
            '<img ng-style="styles()" alt="image" ng-src="{{\'' + assetsPath + '\' + el.imgSrc}}"></div>',
            link: function (scope) {
                scope.styles = function () {
                    var s = scope.el;
                    var styles = {
                        width: valOutput(s.width),
                        height: valOutput(s.height),
                        marginTop: valOutput(s.marginTop),
                        marginBottom: valOutput(s.marginBottom),
                    }
                    if (scope.activeFormStyles.formDirection === 'rtl') {
                        styles.marginRight = valOutput(s.marginSide)
                    } else {
                        styles.marginLeft = valOutput(s.marginSide)
                    }
                    switch (s.align) {
                        case "center":
                            styles.marginLeft = "auto";
                            styles.marginRight = "auto";
                            styles.display = "block";
                            break;
                        case "left":
                            styles.float = "left";
                            break;
                        case "right":
                            styles.float = "right";
                            break;
                    }
                    return styles;
                }
            }
        }
    });

    app.directive("fileElement", function () {
        return {
            restrict: "AE",
            require: "^ngModel",
            template: '<div class="ko-lbl uf-field-label" ng-style="labelStyle(el)">' +
            '<span ng-bind="el.label"></span>' +
            '<span ng-show="el.required === \'true\'" class="uf-alrt"> *</span></div>' +
            '<input type="file" ng-click="$event.preventDefault()"/>'
        }
    });

    app.directive("ufInputSpinner", function () {
        return {
            restrict: "A",
            require: "^ngModel",
            link: function (scope, element, attrs, model) {
                element.on("keydown", function (e) {
                    if (element.attr('disabled') === 'disabled') {
                        return;
                    }
                    var dir = {38: 'up', 40: 'down'}[e.which];
                    if (dir) {
                        e.preventDefault();
                        switch (dir) {
                            case 'up':
                                model.$setViewValue(parseFloat(model.$viewValue) + 1);
                                break;
                            case 'down':
                                model.$setViewValue(parseFloat(model.$viewValue) - 1);
                                break;
                        }
                        element.val(model.$viewValue);
                    }
                });
            }
        }
    });

    app.directive("ufInputMaxPercent", function ($parse) {
        return {
            restrict: "A",
            require: "^ngModel",
            link: function (scope, element, attrs, model) {
                var checkPercent = function () {
                    if (attrs.ufInputMaxPercent === "%") {
                        if (parseFloat(model.$viewValue) > 100) {
                            model.$setViewValue(100);
                            element.val(model.$viewValue);
                        }
                    }
                }
                element.on("blur", checkPercent)
                attrs.$observe("ufInputMaxPercent", checkPercent);
            }
        }
    });

    app.directive("ufImageBrowse", ['ufImageBrowserService', function (ufImageBrowserService) {
        return {
            restrict: "A",
            require: "ngModel",
            scope: {
                ngModel: '='
            },
            template: '<div class="input-group"><input type="text" class="form-control" ng-model="ngModel" /><span class="input-group-btn">' +
            '<button class="btn btn-default" type="button" ng-click="openImgBrowser()">Browse...</button></span></div>',
            link: function (scope, elements, attrs, model) {
                scope.openImgBrowser = function () {
                    ufImageBrowserService.openImgBrowser().then(function (value) {
                        model.$setViewValue(value);
                        model.$render();
                    });
                };
            }
        }
    }]);

    app.directive("ufVisualForm", function ($rootScope) {
        return {
            restrict: "A",
            scope: {
                ufVisualForm: "&",
                ufVisualFormStyles: "="
            },
            link: function (scope, element) {
                element.on("click", function (e) {
                    var currentEl = e.target;
                    var showDetails = false;
                    while (currentEl !== element[0]) {
                        if (currentEl.className.indexOf("field-details") > -1) {
                            showDetails = true;
                            break;
                        }
                        currentEl = currentEl.parentElement;
                    }
                    if (!showDetails) {
                        scope.$apply(function () {
                            scope.ufVisualForm();
                        })
                    }
                });

                var formContainerWidth = ng.element("#uf-form-settings-preview")[0].offsetWidth,
                    formMinWidthEl, formMaxWidthEl, formMinWidth;

                scope.$on("elementResize:start", function (e, obj) {
                    if (obj.element[0] === element[0]) {
                        formMinWidthEl = ng.element("input[data-ng-model='fs.activeFormStyles.formMinWidth.value']");
                        formMaxWidthEl = ng.element("input[data-ng-model='fs.activeFormStyles.formMaxWidth.value']");
                        formMinWidth = ng.copy(scope.ufVisualFormStyles.formMinWidth.value);
                        formMinWidth = parseFloat(scope.ufVisualFormStyles.formMinWidth.unit === "%" ? (formMinWidth / 100) * formContainerWidth : formMinWidth);
                        scope.ufVisualFormStyles.formFullWidth = 'false';
                        scope.ufVisualFormStyles.formMaxWidth.value = obj.width;
                        scope.ufVisualFormStyles.formMaxWidth.unit = "px";
                        //scope.$apply();
                    }
                })
                scope.$on("elementResize:move", function (e, obj) {
                    if (obj.element[0] === element[0]) {
                        formMaxWidthEl.val(Math.ceil(obj.width));
                        if (formMinWidth > obj.width) {
                            formMinWidthEl.val(Math.ceil(obj.width));
                            if (scope.ufVisualFormStyles.formMinWidth.unit !== "px") {
                                scope.ufVisualFormStyles.formMinWidth.unit = "px";
                                //scope.$apply();
                            }
                        }
                    }
                });

                scope.$on("elementResize:end", function (e, obj) {
                    if (obj.element[0] === element[0]) {
                        if (formMinWidth > obj.width) {
                            scope.ufVisualFormStyles.formMinWidth.value = Math.ceil(obj.width);
                        }
                        scope.ufVisualFormStyles.formMaxWidth.value = Math.ceil(obj.width);
                        ng.element('.uf-form').css({"width": "auto"});
                        scope.$apply();
                    }
                });
            }
        }
    });

    app.directive("ufResize", function ($parse, $document, $rootScope, $timeout) {
        return {
            transclude: true,
            template: '<ng-transclude></ng-transclude>' +
            '<div ng-mousedown="eastResize($event)" class="e-resize" ng-show="resizeDir(\'e\') && showResize"><span class="fa-stack fa-lg">' +
            '<i class="fa fa-circle fa-stack-2x"></i><i class="fa fa-arrows-h fa-stack-1x fa-inverse"></i></span></div>' +
            '<div ng-mousedown="southeastResize($event)" class="se-resize" ng-show="resizeDir(\'se\') && showResize"></div>' +
            '<div ng-mousedown="southResize($event)" class="s-resize" ng-show="resizeDir(\'s\') && showResize"></div>',
            link: function (scope, element, attr) {
                var directions = attr.ufResizeDirections.split("");
                var appendedTooltip;
                var reTooltip = ng.element('<div class="re-tooltip fade in tooltip top" role="tooltip"> <div class="tooltip-arrow"></div> <div class="tooltip-inner"></div> </div>');
                var resizeTooltip = {
                    show: function () {
                        ng.element('body').append(reTooltip);
                        appendedTooltip = ng.element('.re-tooltip');
                    },
                    hide: function () {
                        appendedTooltip.remove();
                    },
                    move: function (e, value) {
                        appendedTooltip.css({
                            top: e.clientY - appendedTooltip[0].clientHeight - 5,
                            left: e.clientX - appendedTooltip[0].clientWidth / 2
                        });
                        appendedTooltip.find(".tooltip-inner").text(value + 'px')
                    }
                };

                function clearWHRange(element) {
                    element.css({
                        maxWidth: "none",
                        minWidth: "initial",
                        maxHeight: "none",
                        minHeight: "initial",
                        width: Math.max(parseFloat(element.css("max-width")), parseFloat(element.css("width")), parseFloat(element.css("min-width")))
                    });
                }

                scope.showResize = false;
                scope.resizeDir = function (dir) {
                    return directions.indexOf(dir) > -1;
                };
                attr.$observe("ufResize", function (n) {
                    scope.showResize = $parse(n)();
                });
                // Function to manage resize right event
                var resizeRight = function ($event) {
                    $event.stopPropagation();

                    var viewportOffset = element[0].getBoundingClientRect();
                    var width = $event.pageX - viewportOffset.left;

                    if ($event.pageX > viewportOffset.left + 50) {
                        element.css({
                            width: width + "px"
                        });
                    } else {
                        element.css({
                            width: "50px",
                        });
                    }
                };

                // Function to manage resize down event
                var resizeDown = function ($event) {
                    $event.stopPropagation();
                    var viewportOffset = element[0].getBoundingClientRect();
                    var height = $event.pageY - viewportOffset.top;

                    if ($event.pageY > viewportOffset.top + 50) {
                        element.css({
                            height: height + "px"
                        });
                    } else {
                        element.css({
                            height: "50px"
                        });
                    }
                };
                scope.southeastResize = function ($event) {
                    $event.stopPropagation();
                    $document.on("mousemove", mousemove);
                    $document.on("mouseup", mouseup);
                    element.addClass("uf-resizing");
                    resizeTooltip.show();
                    $rootScope.$broadcast("elementResize:start", {
                        element: element,
                        event: $event,
                        height: element[0].clientHeight,
                        width: element[0].clientWidth
                    });
                    $timeout(function () {
                        clearWHRange(element);
                    }, 100)

                    function mousemove($event) {
                        $event.preventDefault();
                        resizeDown($event);
                        resizeRight($event);
                        resizeTooltip.move($event, element[0].clientWidth + "x" + element[0].clientHeight);
                        $rootScope.$broadcast("elementResize:move", {
                            element: element,
                            event: $event,
                            height: element[0].clientHeight,
                            width: element[0].clientWidth
                        });
                    }

                    function mouseup($event) {
                        $event.stopPropagation();
                        $document.off("mousemove", mousemove);
                        $document.off("mouseup", mouseup);
                        resizeTooltip.hide();
                        element.removeClass("uf-resizing");
                        $rootScope.$broadcast("elementResize:end", {
                            element: element,
                            event: $event,
                            height: element[0].clientHeight,
                            width: element[0].clientWidth
                        });
                    }
                };

                scope.eastResize = function ($event) {
                    $event.stopPropagation();
                    $document.on("mousemove", mousemove);
                    $document.on("mouseup", mouseup);
                    resizeTooltip.show();
                    $rootScope.$broadcast("elementResize:start", {
                        element: element,
                        event: $event,
                        height: element[0].clientHeight,
                        width: element[0].clientWidth
                    });
                    $timeout(function () {
                        clearWHRange(element);
                    }, 100)
                    element.addClass("uf-resizing");
                    function mousemove($event) {
                        $event.preventDefault();
                        resizeRight($event);
                        resizeTooltip.move($event, element[0].clientWidth);
                        $rootScope.$broadcast("elementResize:move", {
                            element: element,
                            event: $event,
                            height: element[0].clientHeight,
                            width: element[0].clientWidth
                        });
                    }

                    function mouseup($event) {
                        $event.stopPropagation();
                        $document.off("mousemove", mousemove);
                        $document.off("mouseup", mouseup);
                        resizeTooltip.hide();
                        element.removeClass("uf-resizing");
                        $rootScope.$broadcast("elementResize:end", {
                            element: element,
                            event: $event,
                            height: element[0].clientHeight,
                            width: element[0].clientWidth
                        });

                    }
                };
                scope.southResize = function ($event) {
                    $event.stopPropagation();
                    $document.on("mousemove", mousemove);
                    $document.on("mouseup", mouseup);
                    resizeTooltip.show();
                    element.addClass("uf-resizing");
                    $rootScope.$broadcast("elementResize:start", {
                        element: element,
                        event: $event,
                        height: element[0].clientHeight,
                        width: element[0].clientWidth
                    });

                    $timeout(function () {
                        clearWHRange(element);
                    }, 100);

                    function mousemove($event) {
                        event.preventDefault();
                        resizeDown($event);
                        resizeTooltip.move($event, element[0].clientHeight);
                        $rootScope.$broadcast("elementResize:move", {
                            element: element,
                            event: $event,
                            height: element[0].clientHeight,
                            width: element[0].clientWidth
                        });
                    }

                    function mouseup($event) {
                        $event.stopPropagation();
                        $document.off("mousemove", mousemove);
                        $document.off("mouseup", mouseup);
                        resizeTooltip.hide();
                        element.removeClass("uf-resizing");
                        $rootScope.$broadcast("elementResize:end", {
                            element: element,
                            event: $event,
                            height: element[0].clientHeight,
                            width: element[0].clientWidth
                        });
                    }
                };
            }
        }
    });

})
(angular)