(function(ng){
    'use strict';

    var app = ng.module("ufApp.services", []);

    app.service("ufElementsDefaultValues", function(){
        return {
            text: {
                type: "text",
                label: "Default Title:",
                value: "",
                required: "false",
                simple_validation: "none",
                _from_form: {
                    width: "fieldWidth",
                    bgType: "fieldBgType",
                    bgStartColor: "fieldBgStartColor",
                    bgEndColor: "fieldBgEndColor",
                    bgImg: "fieldBgImg",
                    bgFit: "fieldBgFit",
                    bgRepeat: "fieldBgRepeat",
                    bgPosition: "fieldBgPosition"
                }
            },
            textarea: {
                type: "textarea",
                label: "Default Title:",
                value: "",
                required: "false",
                simple_validation: "none",
                _from_form: {
                    width: "fieldAreaWidth",
                    height: "fieldAreaHeight",
                    bgType: "fieldBgType",
                    bgStartColor: "fieldBgStartColor",
                    bgEndColor: "fieldBgEndColor",
                    bgImg: "fieldBgImg",
                    bgFit: "fieldBgFit",
                    bgRepeat: "fieldBgRepeat",
                    bgPosition: "fieldBgPosition"
                }
            },
            title: {
                type: "title",
                label: "Default Title"
            },
            paragraph: {
                type: "paragraph",
                label: "Default Paragraph Text"
            },
            checkbox: {
                type: "checkbox",
                label: "Default Title:",
                options: [
                    {
                        value: "first_option",
                        label: "First Option"
                    }, {
                        value: "second_option",
                        label: "Second Option"
                    }, {
                        value: "third_option",
                        label: "Third Option"
                    }
                ],
                _from_form: {
                    labelFieldColor: "labelFieldColor",
                    labelFontSize: "labelFontSize",
                    fieldTextColor: "fieldTextColor",
                    fieldFontSize: "fieldFontSize"
                }
            },
            radio: {
                type: "radio",
                label: "Default Title:",
                options: [
                    {
                        value: "first_option",
                        label: "First Option",
                        checked: true
                    }, {
                        value: "second_option",
                        label: "Second Option"
                    }, {
                        value: "third_option",
                        label: "Third Option"
                    }
                ],
                _from_form: {
                    labelFieldColor: "labelFieldColor",
                    labelFontSize: "labelFontSize",
                    fieldTextColor: "fieldTextColor",
                    fieldFontSize: "fieldFontSize"
                }
            },
            captcha: {
                type: "captcha",
                align: "inherit",
                label: "Enter Captcha",
                placeholder: "",
                borderType: "none",
                borderWidth: "1",
                borderColor: "#000000",
                borderRadius: "0",
                width: "292",
                height: "82"
            },
            select: {
                type: "select",
                label: "Default Title:",
                options: [
                    {
                        value: "first_option",
                        label: "First Option"
                    }, {
                        value: "second_option",
                        label: "Second Option"
                    }, {
                        value: "third_option",
                        label: "Third Option"
                    }
                ],
                _from_form: {
                    width: "fieldWidth",
                    bgType: "fieldBgType",
                    bgStartColor: "fieldBgStartColor",
                    bgEndColor: "fieldBgEndColor",
                    bgImg: "fieldBgImg",
                    bgFit: "fieldBgFit",
                    bgRepeat: "fieldBgRepeat",
                    bgPosition: "fieldBgPosition"
                }
            },
            button: {
                type: "button",
                value: "Send"
            },
            row: {
                type: "row",
                fields: []
            },
            succmess: {
                type: "message-success"
            },
            errmess: {
                type: "message-error"
            },
            loadmess: {
                type: "message-loading"
            },
            image: {
                type: "image",
                _original: {
                    width: null,
                    height: null
                },
                _aspectRatio: null,
                _from_form: {
                    width: "imageWidth",
                    height: "imageHeight",
                    keepRatio: "imageKeepRatio",
                    imgSrc: "imageImgSrc",
                    borderType: "imageBorderType",
                    borderSize: "imageBorderSize",
                    borderColor: "imageBorderColor",
                    borderRadius: "imageBorderRadius",
                    marginTop: "imageMarginTop",
                    marginBottom: "imageMarginBottom",
                    marginSide: "imageMarginSide",
                    align: "imageAlign"
                }
            },
            file: {
                type: "file",
                label: "Default label:",
                maxSize: 10,
                required: "false",
                extensions: "pdf, doc, docx, xls, xlsx, csv, txt, rtf, html, zip, mp3, wma, mpg, flv, avi, jpg, jpeg, png, gif"
            }
        }
    })

    app.service("ufImageBrowserService", function($window, $uibModal, $q){
        var modalInstance;
        $window.ufOnFileModalDismiss = function(){
            modalInstance.dismiss("cancel");
        }
        var imageBrowser = {
            openImgBrowser: function(){
                return $q(function(resolve, reject){
                    if ($window.form.isDemoMode) {
                        alert("Image browser disabled in demo mode");
                        reject();
                    } else {
                        modalInstance = $uibModal.open({
                            animation: true,
                            size: "lg",
                            templateUrl: $window.g_urlAssets + 'templates/image-browse.html'
                        });
                    }
                    $window.ufOnFileModalClose = function(value){
                        resolve(value);
                    }
                });
            }
        }
        return imageBrowser
    })

})(angular)