(function (ng, window) {
    "use strict";

    var app = ng.module("ufApp", [
        'focus-if',
        "ngAnimate",
        "ngSanitize",
        "farbtastic",
        "ui.bootstrap",
        "ufApp.directives.FormElements",
        "ufApp.services.formService",
        "ufApp.controllers",
        "uf.templates",
        "ufApp.services"
    ]);

    app.factory("httpInterceptor", function(){
        return {
            request: function(request){
                if(request.method === 'GET' && request.cache && !request.cache.get(request.url) && request.url){
                    var sepUrl = request.url.indexOf("?") === -1 ? "?" : "&";
                    request.url += sepUrl + '_=' + (new Date()).valueOf();
                }
                return request
            }
        }
    });

    app.config(['$httpProvider', '$provide', "uibButtonConfig", function($httpProvider, $provide, uibButtonConfig){
        uibButtonConfig.activeClass = "active-btn";
        $provide.constant("ufFormActionsUrls", window.g_formActionsUrls);
        $httpProvider.interceptors.push('httpInterceptor');

    }]);
})
(angular, window);