(function (ng) {
    'use strict';

    var app = ng.module("ufApp.controllers.formPreviewCtrl", []);

    app.controller("formPreviewCtrl", ["$scope", "$window", function ($scope, $window) {
        var self = this;
        self.showLeftCol = true;
        self.formTitle = $window.form.title;
        self.previewDevices = [{
            type: "mobile",
            width: "480px",
            icon: "mobile"
        }, {
            type: "tablet",
            width: "768px",
            icon: "tablet fa-rotate-90"
        }, {
            type: "desktop",
            width: "100%",
            icon: "desktop",
            _active: true
        }];

        self.previewBg = [{
            color: "#000000",
            img: false
        },{
            color: "#ffffff",
            img: false,
            _active: true
        },{
            color: "#8a8a8a",
            img: false
        },{
            color: "#575b6d",
            img: false
        },{
            color: "transparent"
        }];

        self.setActive = function(activeEl, elements){
            elements.forEach(function(bg){
                bg._active = false;
            });
            activeEl._active = true;
        };

        self.setFormPreviewStyles = function(){
            var bg = self.previewBg.filter(function(bg){
                return bg._active
            })[0];
            var device = self.previewDevices.filter(function(bg){
                return bg._active
            })[0];
            var styles = {
                backgroundColor: bg.color,
                backgroundImage: bg.img === false ? "none" : null,
                width: device.width
            };
            return styles;
        };
        self.toggleLeftCol = function () {
            self.showLeftCol = !self.showLeftCol;
        };
    }]);
})(angular)