<?php

/**
 * @package Unite Forms for Joomla 1.7-3.5
 * @author UniteCMS.net
 * @copyright (C) 2014 Unite CMS, All Rights Reserved.
 * @license GNU/GPLv3 http://www.gnu.org/licenses/gpl-3.0.html
 * */

defined('_JEXEC') or die;


class UniteFormsActions {

	
    /**
     * 
     * get file data
     */
    private function getFileData($filepath) {
        $r = (object) null;
        try {
            $r->data = UniteFunctionsForms::readFile($filepath);
            $r->success = true;
        } catch (Exception $ex) {
            $r->data = '';
            $r->success = false;
            $r->message = $ex->getMessage();
        }
        $json = json_encode($r);

        return $json;
    }

    
    
    /**
     * operate from action front
     */
    public function operateFront(){
    	
    	$action = UniteFunctionsForms::getPostGetVar("client_action");
    	    	
    	$action = trim($action);
    	
    	$data = UniteFunctionsForms::getPostGetVar("data");
    	
    	if(is_string($data))
    		$data = json_decode($data);
    	
    	$data = UniteFunctionsForms::convertStdClassToArray($data);
    	
    	$form = new UniteFormsForm();
    	
		try{
	    	switch ($action) {
	    		case "save_visual":
	    			
	    			UniteFunctionsForms::ajaxResponseSuccess("Settings not saved, moving to preview...");
	   			break;
	    		case "get_settings":
	    			$jsonData = $form->getFieldsFromData($data);
	    			echo $jsonData;
	    			exit();
	   			break;
	    		case "sendform":
	    			try {
	    				
	    				$operations = new UniteFormsOperations();
	    				$output = $operations->sendFormFromData($data);
	    				$form->initByID($data['formID'] ); // need inited form so we can get it's success pseudo-field label
	    				UniteFunctionsForms::ajaxResponseSuccess( $form->getSuccessMessageText(), $output);
						
	    			} catch (Exception $e) {
	    				$message = $e->getMessage();
	    				UniteFunctionsForms::ajaxResponseError($message);
	    				exit();
	    			}
	   			break;
	   			default:
	   				UniteFunctionsForms::throwError("wrong action: " . $action);
	   			break;
	    	}
        } catch (Exception $e) {
            $message = $e->getMessage();
            $trace = $e->getTraceAsString();
            
            $message = "Error: <b>{$message}</b>";
            
            if (GlobalsUniteForms::SHOW_TRACE == true)
                $message .= "<pre>".print_r($trace, true)."</pre>";
            
            UniteFunctionsForms::ajaxResponseError($message);

        }
        
        exit();
    }
    
    
    /**
     * 
     * operate all the actions
     */
    public function operate() {

        $action = UniteFunctionsForms::getPostGetVar("client_action");
        
        $action = trim($action);

        $data = UniteFunctionsForms::getPostGetVar("data");
        
        if(is_string($data)){
        	$data = json_decode($data);
        	$data = UniteFunctionsForms::convertStdClassToArray($data);
        	if(empty($data)){
        		$data = $_REQUEST;
        	}
        }
        
        $form = new UniteFormsForm();
        
        $urlViewForms = HelperBackendUF::getUrlView(GlobalsUniteForms::VIEW_FORMS);
        $urlViewTemplates = HelperBackendUF::getUrlView(GlobalsUniteForms::VIEW_FORM_TEMPLATES);
        
        $templates = new UniteFormsTemplates();
		
        
        try {

            switch ($action) {
            	case "export_form":
            		$form->exportFromData($data);
            	break;
            	case "import_form":
            		$form->importFromData($data);
                    UniteFunctionsForms::ajaxResponseSuccess("Form imported successfully");
                break;
                case "save_visual":
                    $form->updateVisualSettingsFromData($data);
                    UniteFunctionsForms::ajaxResponseSuccess("Settings Saved");
                break;
                case "get_settings":
                    $jsonData = $form->getFieldsFromData($data);
                    echo $jsonData;
                break;
                case "get_styles":
                    $formData = $form->getFormStylesAndSettings($data);
                    UniteFunctionsForms::ajaxResponseSuccess( $formData );
                break;
                case "add_form":
                    $form->addForm();
                    UniteFunctionsForms::ajaxResponseSuccessRedirect("Form added, refreshing...", $urlViewForms);
                break;
                case "list_forms":
                    UniteFunctionsForms::ajaxResponseSuccess( $form->listAll() );
                break;
                case "delete_form":
                    $form->deleteFormFromData($data);
                    UniteFunctionsForms::ajaxResponseSuccessRedirect("Form deleted", $urlViewForms);
                break;
                case "duplicate_form":
                	$form->duplicateFormFromData($data);
                	UniteFunctionsForms::ajaxResponseSuccessRedirect("Form duplicated", $urlViewForms);
                break;
                case "sendform":
                    try {
						
                    	$operations = new UniteFormsOperations();
                        $operations->sendFormFromData($data, true);
						$form->initByID($data['formID'] ); // need inited form so we can get it's success pseudo-field label
                        UniteFunctionsForms::ajaxResponseSuccess( $form->getSuccessMessageText() );
                    
                    } catch (Exception $e) {
                        $message = $e->getMessage();
                        UniteFunctionsForms::ajaxResponseError($message);
                        exit();
                    }
                break;
                case "create_template":
                	
                	$templates->createTemplateFromData($data);
                	UniteFunctionsForms::ajaxResponseSuccessRedirect("Template Created...", $urlViewForms);
                	
                break;
                case "delete_template":
                	
                	$templates->deleteTemplateByData($data);
                	UniteFunctionsForms::ajaxResponseSuccessRedirect("Template Deleted...", $urlViewTemplates);
                	
                break;
                case "save_form_title":

                	$form->updateTitleFromData($data);
                	UniteFunctionsForms::ajaxResponseSuccess( "Title Updated" );

                break;
                default:
                	UniteFunctionsForms::throwError("wrong action: " . $action);
                break;
            }
        } catch (Exception $e) {
            $message = $e->getMessage();
            $trace = $e->getTraceAsString();
            
            $message = "Error: <b>{$message}</b>";
            
            if (GlobalsUniteForms::SHOW_TRACE == true)
                $message .= "<pre>".print_r($trace, true)."</pre>";
            
            UniteFunctionsForms::ajaxResponseError($message);

        }
        
        exit();
    }

}

?>