<?php

/**
 * @package Unite Forms for Joomla 1.7-3.5
 * @author UniteCMS.net
 * @copyright (C) 2014 Unite CMS, All Rights Reserved.
 * @license GNU/GPLv3 http://www.gnu.org/licenses/gpl-3.0.html
 * */

defined('_JEXEC') or die;


	class HelperBackendUF{
		
		
		/**
		 * get form layout
		 */
		public static function getUrlFormLayout($layout = "", $params = ""){
			
			$url = self::getUrlView(GlobalsUniteForms::VIEW_FORM, $layout, $params);
			
			return($url); 
		}
		
		/**
		 * 
		 * get view url, validate the view file is there.
		 */
		public static function getUrlView($view,$layout="",$params = ""){
			
			$url = GlobalsUniteForms::$urlComponent;
			if(strpos($url, "?") !== false)
				$url .= "&view=$view";
			else
				$url .= "?view=$view";
				
			if(!empty($layout))
				$url .= "&layout=".$layout;
			
			if(!empty($params))
				$url .= "&".$params;
			
			return($url);
		}
		
		
		
		/**
		 * 
		 * get template url, validate the view file is there.
		 */
		public static function getPathTemplate($template){
			$filepath = GlobalsUniteForms::$pathTemplates.$template.".php";
			
			UniteFunctionsForms::validateFilepath($filepath, "Template file ");
			
			return($filepath);
		}
		
		
		/**
		 * 
		 * get view path
		 */
		public static function getPathView($view){
			
			$filename = $view.".php";
			
			$filepath = GlobalsUniteForms::$pathViews.$filename;
			
			UniteFunctionsForms::validateFilepath($filepath,"View file don't exists: $filepath");
			
			return($filepath);
			
		}

		
		/**
		 * put admin includes
		 */
		public static function putAdminIncludes(){
			
			ProviderFunctionsUF::addAdminFramework();
			
			ProviderFunctionsUF::addScript("angular", "js/vendor/angular.min.js");
			ProviderFunctionsUF::addScript("angular-animate", "js/vendor/angular-animate.min.js");
			
			$urlProviderAdmin = GlobalsUniteForms::$urlProvider."assets/provider_admin.js";
			
			ProviderFunctionsUF::addScriptAbsoluteUrl("uf_provider_admin", $urlProviderAdmin);
			
			ProviderFunctionsUF::addScript("angular-sanitize", "js/vendor/angular-sanitize.min.js");
			ProviderFunctionsUF::addScript("focusIf", "js/vendor/focusIf.min.js");
			ProviderFunctionsUF::addScript("farbtastic-js", "js/vendor/farbtastic/farbtastic.js");
			ProviderFunctionsUF::addScript("angular-ui-tree", "js/vendor/sortable/angular-ui-tree.js");
			ProviderFunctionsUF::addScript("form-ui-bootstrap-tpls", "js/vendor/ui-bootstrap-tpls-0.14.3.js");
			ProviderFunctionsUF::addScript("ng-file-upload", "js/vendor/ng-file-upload-all.min.js");
			ProviderFunctionsUF::addScript("FarbtasticDirective", "js/FarbtasticDirective.js");
			ProviderFunctionsUF::addScript("FormElementsDirective", "js/FormElementsDirective.js");
			ProviderFunctionsUF::addScript("FormService", "js/FormService.js");
			ProviderFunctionsUF::addScript("FormsListController", "js/controllers/FormsListController.js");
			ProviderFunctionsUF::addScript("FormVisualController", "js/controllers/FormSettingsController.js");
			ProviderFunctionsUF::addScript("FormNavigationController", "js/controllers/FormNavigationController.js");
			ProviderFunctionsUF::addScript("FormPreviewController", "js/controllers/FormPreviewController.js");
			ProviderFunctionsUF::addScript("FormMainController", "js/controllers/FormMainController.js");
			ProviderFunctionsUF::addScript("ImageBrowserService", "js/UniteFormServices.js");
			ProviderFunctionsUF::addScript("unite-forms-main", "js/controllers/main.js");
			ProviderFunctionsUF::addScript("unite-forms-templates", "js/templates.js");
			ProviderFunctionsUF::addScript("unite-forms-app", "js/app.js");
			
			ProviderFunctionsUF::addScript("unite-forms-plugin-js", "uf-plugin/unite-forms.js");
			
			ProviderFunctionsUF::addStyle("farbtastic-css", "js/vendor/farbtastic/farbtastic.css");
			ProviderFunctionsUF::addStyle("unite-forms-app", "css/app.css");
			ProviderFunctionsUF::addStyle("unite-forms-plugin-css", "uf-plugin/unite-forms.css");
			
			//add ajax url:
			$currentView = UniteFunctionsForms::getGetVar("view",GlobalsUniteForms::VIEW_FORMS);
			
			$ajaxUrl = HelperBackendUF::getUrlView($currentView, "ajax");
			
			$urlAssets = GlobalsUniteForms::$urlAssets;
			$urlRoot = GlobalsUniteForms::$urlRoot;

			$formLinks = array(
				"visualView" => HelperBackendUF::getUrlFormLayout("visual"),
				"previewView" => HelperBackendUF::getUrlFormLayout("preview"),
				"formsView" => HelperBackendUF::getUrlView(GlobalsUniteForms::VIEW_FORMS)
			);
			
			ProviderFunctionsUF::addScriptInline("var g_urlAjaxActions='$ajaxUrl';");
			ProviderFunctionsUF::addScriptInline("var g_urlAssets='$urlAssets';");
			ProviderFunctionsUF::addScriptInline("var g_urlRoot='$urlRoot';");
			ProviderFunctionsUF::addScriptInline("var g_formActionsUrls=".json_encode($formLinks).";");
			
		}
		
		
	}