<?php

/**
 * @package Unite Forms for Joomla 1.7-3.5
 * @author UniteCMS.net
 * @copyright (C) 2014 Unite CMS, All Rights Reserved.
 * @license GNU/GPLv3 http://www.gnu.org/licenses/gpl-3.0.html
 * */

defined('_JEXEC') or die;


class UniteFormsBase extends UniteFormBaseClass {

    public static $db_global;
    private static $is_init = false;
    protected $params = null;

    const MODE_VALIDATE_EXISTS = "validate";
    const MODE_VALIDATE_NUMERIC = "numeric";
    const MODE_FORCE_NUMERIC = "force_numeric";
    const MODE_FORCE_BOOLEAN = "force_boolean";
	const MODE_FORCE_HEX = "force_hex";
    const MODE_WIDTH_FIELD = "width_field";

    /**
     * 
     * constructor
     */
    public function __construct() {
        
    	parent::__construct();
        
    }

    /**
     *
     * get param from params
     * @param $name
     * @param string $default
     * @param null $mode
     * @param null $arrParams
     * @return bool|float|string
     * @throws Exception
     */
    public function getParam($name, $default = "", $mode = null, $arrParams = null) {
		
        if ($arrParams === null) {
            $value = UniteFunctionsForms::getVal($this->params, $name, $default);

            if (GlobalsUniteForms::VALIDATE_OUTPUT_FIELDS == true && array_key_exists($name, $this->params) == false)
                UniteFunctionsForms::throwError("The param <b> $name </b> does not exists in params");
            
            $arrParams = $this->params;
        }
        else {
            $value = UniteFunctionsForms::getVal($arrParams, $name, $default);
            if (GlobalsUniteForms::VALIDATE_OUTPUT_FIELDS == true && array_key_exists($name, $arrParams) == false)
                UniteFunctionsForms::throwError("The param <b> $name </b> does not exists in custom params");
		}

        switch ($mode) {
            case self::MODE_VALIDATE_EXISTS:
                if (array_key_exists($name, $arrParams) == false)
                    UniteFunctionsForms::throwError("The param: {$name} don't exists");
                break;
            case self::MODE_VALIDATE_NUMERIC:
                if (is_numeric($value) == false)
                    UniteFunctionsForms::throwError("The param: {$name} is not numeric");
                break;
            case self::MODE_FORCE_NUMERIC:
                $value = floatval($value);
                $value = (double) $value;
                break;
			
            case self::MODE_WIDTH_FIELD:  //it can be %
                $value = strtolower($value);
                if (strpos($value, "px") === false) {
				/* we no longet need this. because we now save values */
                    //$value .= "px";
				}
                break;
            case self::MODE_FORCE_BOOLEAN:
            	$value = UniteFunctionsForms::strToBool($value);
            break;
            case self::MODE_FORCE_HEX:
            	$value = UniteFunctionsForms::anythingToHex($value);
            break;
        }

        return($value);
    }

}

?>
