<?php

/**
 * @package Unite Forms for Joomla 1.7-3.5
 * @author UniteCMS.net
 * @copyright (C) 2014 Unite CMS, All Rights Reserved.
 * @license GNU/GPLv3 http://www.gnu.org/licenses/gpl-3.0.html
 * */

defined('_JEXEC') or die;


class UniteFormsForm extends UniteFormsBase {

    const TYPE_RADIO = "radio";
    const TYPE_SELECT = "select";
    const TYPE_CHECKBOX = "checkbox";
    const TYPE_TEXT = "text";
    const TYPE_BUTTON = "button";
    const TYPE_CAPTCHA = "captcha";
    const TYPE_PARAGRAPH = "paragraph";
    const TYPE_TITLE = "title";
    const TYPE_SUCCESS_MESSAGE = "succmess";
    const TYPE_ERROR_MESSAGE = "errmess";
    const TYPE_LOAD_MESSAGE = "loadmess";
    const TYPE_FILE = "file";


    private $formID;
    private $arrFields = array();
    private $title;
    private $alias;
	private $record;
    
    public function __construct() {
        $this->db = new UniteFormsDB();  //for function recognising

        parent::__construct();
    }

    private function _______________COMMON_______________() {
    }


    /**
     *
     * validate that the form is inited
     */
    private function validateInited() {

        if (empty($this->formID))
            UniteFunctionsForms::throwError("The form is not inited");
    }

    
	/**
	 * get all forms short
	 */
    public function listAll() {
    	
        $records = array();
        try {
            $result = $this->db->fetch(GlobalsUniteForms::$table_forms);
            
            foreach ($result as $form) {
            	
            	$alias = UniteFunctionsForms::getVal($form, "alias");
            	
            	$shortcode = "{uniteforms $alias}";
                $options = json_decode(stripslashes($form['options']));
                $records[] = array(
                    "id" => $form['id'],
                    "title" => $form["title"],
                    "shortcode" => $shortcode
                );
            }
        } catch (Exception $e) {
            $message = $e->getMessage();
            $trace = $e->getTraceAsString();

            if (GlobalsUniteForms::SHOW_TRACE == true)
                $message .= $trace;

            UniteFunctionsForms::throwError($message);
        }
        return $records;
    }


    
    /**
     * init form by alias
     */
    public function initByAlias($alias){
    	UniteFunctionsForms::validateNotEmpty($alias, "form alias");
    	$alias = $this->db->escape($alias);
    	
    	$records = $this->db->fetch(GlobalsUniteForms::$table_forms, "alias='{$alias}'");
    	if(empty($records))
    		UniteFunctionsForms::throwError("form with alias='$alias' not found");
    	
    	$record = $records[0];
    	
    	$formID = UniteFunctionsForms::getVal($record, "id");
    	$this->initByID($formID);
    }
    
    
    /**
     *
     * init form by ID
     * @param $id
     * @throws Exception
     */
    public function initByID($id) {

        UniteFunctionsForms::validateNumeric($id, "Form ID");

        try {

            $record = $this->db->fetch(GlobalsUniteForms::$table_forms, "id={$id}");
            if (empty($record))
                UniteFunctionsForms::throwError("Form with id: $id not found");

            $this->initFromDBRecord($record[0]);
        } catch (Exception $e) {
            $message = $e->getMessage();
            $trace = $e->getTraceAsString();

            if (GlobalsUniteForms::SHOW_TRACE == true)
                $message .= $trace;

            UniteFunctionsForms::throwError($message);
        }
    }

    
    /**
     *
     * init from record
     * @param $record
     */
    public function initFromDBRecord($record) {
    	
    	$this->record = $record;
    	
        $operations = new UniteFormsOperations();

        //set fields
        $this->formID = UniteFunctionsForms::getVal($record, "id");
        $this->title = UniteFunctionsForms::getVal($record, "title");
        $this->alias = UniteFunctionsForms::getVal($record, "alias");

        //set params
        $arrParams = UniteFunctionsForms::getValArr($record, "params");
		
        $arrOptions = UniteFunctionsForms::getValArr($record, "options");
        $arrFields = UniteFunctionsForms::getValArr($record, "fields");

        $arrParams["form_title"] = $this->title;
        $arrParams["form_alias"] = $this->alias;

        $params = array_merge($arrParams, $arrOptions);

        //merge with default params
        $params = $operations->getCombinedSettingsForm($params);

        $this->params = $params;

        $arrFields = UniteFunctionsForms::convertStdClassToArray($arrFields);

        //make fields assoc
        $arrFieldsAssoc = array();
        foreach ($arrFields as $key => $field) {
            $id = UniteFunctionsForms::getVal($field, "id");
            $arrFieldsAssoc[$id] = $field;
        }

        $this->arrFields = $arrFieldsAssoc;
    }


    /**
     *
     * set field values from key=>value array
     * include files if exists
     */
    public function setFieldValues($arrValues) {

        foreach ($this->arrFields as $index => $field) {
            $fieldID = UniteFunctionsForms::getVal($field, "id");
            $fieldType = UniteFunctionsForms::getVal($field, "type");

            //set all other values
            if (!empty($fieldID)) {

                if (array_key_exists($fieldID, $arrValues)) {
                    $value = UniteFunctionsForms::getVal($arrValues, $fieldID);
                    $this->arrFields[$index]["value"] = $value;
                }
            }

            //set additional params by type
            switch($fieldType){
            	case self::TYPE_CAPTCHA:
            		$captchaValue = UniteFunctionsForms::getVal($arrValues, "captcha");
            		$this->arrFields[$index]["value"] = $captchaValue;
            	break;
            	case self::TYPE_FILE:
            		$arrFile = UniteFunctionsForms::getVal($_FILES, $fieldID);
            		if(!empty($arrFile))
            			$this->arrFields[$index]["file"] = $arrFile;
            	break;
            }
			
        }

    }

    /**
     * get if the type is input type or not
     */
    private function isInteractiveType($type) {

        switch ($type) {
            case self::TYPE_BUTTON:
            case self::TYPE_ERROR_MESSAGE:
            case self::TYPE_SUCCESS_MESSAGE:
            case self::TYPE_LOAD_MESSAGE:
            case self::TYPE_PARAGRAPH:
            case self::TYPE_TITLE:
                return (false);
            break;
        }

        return (true);
    }

    
    /**
     * validate file field
     */
    public function validateFileField($field){
    	
    	//validate file if exists
    	$arrFile = UniteFunctionsForms::getVal($field, "file");
    	
    	if(empty($arrFile))
    		return(false);
    	
   		$filename = UniteFunctionsForms::getVal($arrFile, "name");
    	
   		//validate max size
   		$maxSize = (int)UniteFunctionsForms::getVal($field, "maxSize", 10);
   		$maxSizeBytes = $maxSize*1024*1024;	//in kb
   		$fileSize = UniteFunctionsForms::getVal($arrFile, "size");
   		if($fileSize > $maxSizeBytes)
   			UniteFunctionsForms::throwError("The file <b>$filename</b> is too big, it should be under $maxSize MB");
    	
   		//validate extensions
   		$extensions = UniteFunctionsForms::getVal($field, "extensions");
   		$extensions = str_replace(" ", "", $extensions);
   		$extensions = strtolower($extensions);
   		$arrExtensions = explode(",", $extensions);
    	
   		$fileInfo = pathinfo($filename);
   		$ext = UniteFunctionsForms::getVal($fileInfo, "extension");
   		$ext = strtolower($ext);
   		
    	if(array_search($ext, $arrExtensions) === false)
    		UniteFunctionsForms::throwError("File type not alowed: <b>$filename</b>");
    	
    }
	
    
    /**
     *
     * validate the form
     * the values must be set
     * if error found, throw error. Must be catch in parent side
     */
    public function validateForm() {
				
        foreach ($this->arrFields as $name => $field) {

            $type = UniteFunctionsForms::getVal($field, "type");

            if ($this->isInteractiveType($type) == false)
                continue;

            $value = UniteFunctionsForms::getVal($field, "value");
            $label = UniteFunctionsForms::getVal($field, "label");
			$labelOutput = str_replace(":", "", $label);
            
            //validate required
            $required = UniteFunctionsForms::getVal($field, "required");
            $required = UniteFunctionsForms::strToBool($required);
			
            switch($type){
            	case self::TYPE_CAPTCHA:
            		$operations = new UniteFormsOperations();
            		if ($operations->checkCaptcha($value) == false)
            			UniteFunctionsForms::throwError("The captcha value is wrong.");
            	break;
            	case self::TYPE_FILE:
            		if($required == true && empty($value))
            			UniteFunctionsForms::throwError("please select some file in : <b>{$labelOutput}</b> field.");
            		
            		$this->validateFileField($field);
            	break;
            }
            
            if ($required == true && empty($value))
            	UniteFunctionsForms::throwError("The required field: {$labelOutput} should be filled.");
            
            //validate other validation types
            $validationType = UniteFunctionsForms::getVal($field, "simple_validation");

            switch ($validationType) {
                case "numeric":
                    if (is_numeric($value) == false)
                        UniteFunctionsForms::throwError("The field: <b>{$label}</b> should be numeric.");
                    break;
                case "email":
                    if (UniteFunctionsForms::isEmailValid($value) == false)
                        UniteFunctionsForms::throwError("The email should be valid in field: <b>{$label}</b>");
                    break;
            }

        }
    }

    /**
     * validate that the email is valid
     */
    private function validateEmail($email, $name = "email", $allowEmpty = false) {

        if ($allowEmpty == true && empty($email))
            return (false);

        if (UniteFunctionsForms::isEmailValid($email) == false) {
            if (empty($email))
                $email = "[empty string]";

            UniteFunctionsForms::throwError("The option <b>{$name}</b>: '{$email}' not valid. Please check this option");
        }

    }


    /**
     *
     * send message to admin
     */
    public function sendToAdmin($previewMode) {

        $message = $this->getMessageToAdmin();
		
        $subject = $this->getParam("admin_email_subject");
        if (empty($subject))
            UniteFunctionsForms::throwError("Empty email to admin subject. Please write some subject");

        $emailTo = $this->getParam("admin_email_to");
        $this->validateEmail($emailTo, "admin email to");

        $emailCC = $this->getParam("admin_email_to_cc");
        $this->validateEmail($emailTo, "admin email cc", true);

        $emailCC = $this->getParam("admin_email_to_cc");
        $this->validateEmail($emailTo, "admin email cc", true);

        $emailBCC = $this->getParam("admin_email_to_bcc");
        $this->validateEmail($emailTo, "admin email bcc", true);


        $emailFrom = $this->getParam("admin_email_from_address");
        $emailFromName = $this->getParam("admin_email_from_name");

        //get from name from inputs
        $fieldFromNameID = $this->getParam("field_name");
        if (!empty($fieldFromNameID)) {
            $fromNameInput = $this->getFieldValue($fieldFromNameID);
            if (!empty($fromNameInput))
                $emailFromName = $fromNameInput;
        }

        $fieldFromEmailID = $this->getParam("field_email");
        if (!empty($fieldFromEmailID)) {
            $fromEmailInput = $this->getFieldValue($fieldFromEmailID);
            if (!empty($fromEmailInput) && UniteFunctionsForms::isEmailValid($fromEmailInput)) {
                $emailFrom = $fromEmailInput;
            }
        }
		

        if (GlobalsUniteForms::SEND_EMAIL == false || $previewMode == true)
            return (false);

		
        $arrFiles = $this->getArrFilesFromFields();
        
        
        //----------------------
        //       SEND EMAIL
        try {

            $mailer = JFactory::getMailer();
            $mailer->isHtml(true);

            $mailer->AddAddress($emailTo);

            if (!empty($emailCC))
                $mailer->AddCC($emailCC);

            if (!empty($emailBCC))
                $mailer->AddBCC($emailBCC);

            $mailer->SetFrom($emailFrom, $emailFromName);

            $mailer->setSubject($subject);

            $mailer->setBody($message);
            
            //attach files
            foreach($arrFiles as $file){
            	$filepath = UniteFunctionsForms::getVal($file, "tmp_name");
            	if(!file_exists($filepath))
            		continue;
            	
            	$fileType = UniteFunctionsForms::getVal($file, "type");
            	$fileName = UniteFunctionsForms::getVal($file, "name");
            	
            	$mailer->addAttachment($filepath, $fileName);
            }
            
            $mailer->isHtml(true);

            $sendOutput = $mailer->Send();

            if ($sendOutput !== true) {
                if(getType($sendOutput) == "boolean"){
					UniteFunctionsForms::throwError("the email could not send. Please check that joomla can send emails or admin email address");
				}else{
					$message = $sendOutput->__toString();
					UniteFunctionsForms::throwError($message);
				}
            }

        } catch (Exception $e) {
            $message = "Send email error: " . $e->getMessage();
            UniteFunctionsForms::throwError($message);
        }


    }


    private function _______________GETTERS_______________() {
    }


    /**
     *
     * get option lanel from selected value
     *
     */
    private function getOptionLabel($options, $optionValue) {

        $responseValue = $optionValue;

        foreach ($options as $option) {
            $value = UniteFunctionsForms::getVal($option, 0);
            $label = UniteFunctionsForms::getVal($option, 1);
            if ($optionValue == $value)
                $responseValue = $label;
        }

        return ($responseValue);
    }

    /**
     *
     * get title from inited form
     */
    public function getTitle() {
        $this->validateInited();

        return ($this->title);
    }

    /**
     *
     * get alias
     */
    public function getAlias() {
        $this->validateInited();
        return ($this->alias);
    }

    /**
     *
     * get params
     */
    public function getParams() {
        $this->validateInited();
        return ($this->params);
    }

    /**
     * get redirect after send param.
     * If no need return empty string
     */
    public function getParamRedirectAfterSend() {

        $isRedirect = $this->getParam("redirect_after_success");
        $isRedirect = UniteFunctionsForms::strToBool($isRedirect);
        if ($isRedirect == false)
            return "";

        $redirectLink = $this->getParam("redirect_link");
        return ($redirectLink);
    }


    /**
     * merge existing params with the new ones and get the mixed one
     */
    public function getMergedParams($arrParams) {
        $params = $this->getParams();
        $params = UniteFunctionsForms::mergeComplexArrays($params, $arrParams);
        return ($params);
    }


    /**
     *
     * get fields array
     */
    public function getArrFields($filterType = "") {
        $this->validateInited();

        $arrFields = array();
        foreach ($this->arrFields as $field) {
            $type = UniteFunctionsForms::getVal($field, "type");
			if(!empty($filterType) && $type != $filterType)
				continue;
			
            $arrFields[] = $field;
        }

        return ($arrFields);
    }

    
    /**
     * get files array from fields
     */
    private function getArrFilesFromFields(){
    	$arrFiles = array();
    	$arrFileFields = $this->getArrFields(self::TYPE_FILE);
    	
    	if(empty($arrFileFields))
    		return(array());
    	
    	foreach($arrFileFields as $field){
    		$file = UniteFunctionsForms::getVal($field, "file");
    		if(!empty($file))
    			$arrFiles[] = $file;
    	}
    	
    	
    	return($arrFiles);
    }
    
    
    /**
     *
     * get key / value of the fields
     */
    public function getArrFieldsShort() {

        $arrShort = array();

        $arrFields = $this->getArrFields();
        foreach ($arrFields as $key => $field) {

            $fieldID = UniteFunctionsForms::getVal($field, "id");
            $label = UniteFunctionsForms::getVal($field, "label");

            $arrShort[$fieldID] = $label;
        }

        return ($arrShort);
    }

    
    /**
     *
     * get form id
     */
    public function getID() {
        $this->validateInited();
        return ($this->formID);
    }


    /**
     * get options value
     */
    private function getArrLabelValue_getOptions($field) {

        $options = UniteFunctionsForms::getVal($field, "options");

        if (!is_array($options)) {
            $output = "[nothing selected]";
            return ($output);
        }

        $value = UniteFunctionsForms::getVal($field, "value");

        if (strpos($value, ","))
            $value = explode(",", $value);

        $output = "";

        foreach ($options as $option) {

            $optionValue = UniteFunctionsForms::getVal($option, "value");
            $optionValue = (string)$optionValue;

            $checked = false;
            if (is_array($value) && array_search($optionValue, $value) !== false)
                $checked = true;
            else    //string
                if ($optionValue == $value)
                    $checked = true;

            if ($checked == true) {

                $optionLabel = UniteFunctionsForms::getVal($option, "label");

                if (!empty($output))
                    $output .= " , ";

                $output .= $optionLabel;
            }
        }

        if (empty($output))
            $output = "[nothing selected]";

        return ($output);
    }


    /**
     *
     * get array of label / value only of fields that can have one
     */
    private function getArrLabelValue() {

        $arrResponse = array();
		
        foreach ($this->arrFields as $field) {

            $label = UniteFunctionsForms::getVal($field, "label");
            $value = UniteFunctionsForms::getVal($field, "value");
            $type = UniteFunctionsForms::getVal($field, "type");

            if ($this->isInteractiveType($type) == false)
                continue;

            switch ($type) {
                case self::TYPE_SELECT:
                case self::TYPE_RADIO:
                case self::TYPE_CHECKBOX:
                    $value = $this->getArrLabelValue_getOptions($field);
                    break;
            } //end foreach

            $arrResponse[$label] = $value;
        }

        return ($arrResponse);
    }


    /**
     *
     * get success message label
     **/
    public function getSuccessMessageText() {
		
    	$defaultMessage = 'Form sent successfully!';
    	
    	$arrSuccMess = $this->getParam("succmess");
    	$label = UniteFunctionsForms::getVal($arrSuccMess, "label");
    	
    	if(!empty($label))
    		return($label);

        return ($defaultMessage);
    }

    /**
     *
     * get form fields from data
     */
    public function getFieldsFromData($data) {

        $formID = UniteFunctionsForms::getVal($data, "formID");
        $this->initByID($formID);
        $fields = $this->getArrFields();
		
        $jsonFields = json_encode($fields);
		
        $response = (object)null;
        
        $response->data = $jsonFields;
        $response->success = true;
        $response = json_encode($response);

        return ($response);
    }

    public function getFormStylesAndSettings($data) {
        $formID = UniteFunctionsForms::getVal($data, "formID");
        $this->initByID($formID);

        $settingsGeneral = new UniteSettingsForms();
        $settingsOptions = new UniteSettingsForms();

        $settingsGeneral->loadXMLFile(GlobalsUniteForms::$pathSettings."general.xml");
        $settingsOptions->loadXMLFile(GlobalsUniteForms::$pathSettings."form_options.xml");

        $templates = new UniteFormsTemplates();
        $arrTemplatesFieldsShort = $templates->getArrTemplatesShort(UniteFormsTemplates::TEMPLATE_TYPE_FIELDS, true);
        $arrTemplatesStylesShort = $templates->getArrTemplatesShort(UniteFormsTemplates::TEMPLATE_TYPE_STYLE, true);
        //update settings, fill with template values:
        $settingTemplate = $settingsGeneral->getSettingByName("formTemplate");
        $settingTemplate["items"] = $arrTemplatesFieldsShort;
        $settingsGeneral->updateArrSettingByName("formTemplate", $settingTemplate);

        $settingformStyle = $settingsGeneral->getSettingByName("formStyle");
        $settingformStyle["items"] = $arrTemplatesStylesShort;
        $settingsGeneral->updateArrSettingByName("formStyle", $settingformStyle);

        //update form options
        $settingsOptions->updateSettingValue("form_title", $this->getTitle());
        $settingsOptions->updateSettingValue("form_alias", $this->getAlias());

        $arrFields = $this->getArrFieldsShort();
        $arrFirst = array("","Not Selected");
        $arrFields = array_merge($arrFirst,$arrFields);

        $settingsOptions->updateSettingItems("field_name", $arrFields);
        $settingsOptions->updateSettingItems("field_email", $arrFields);
        $settingsOptions->updateSettingItems("field_phone", $arrFields);

        $arrValues = $this->getParams();
        $settingsGeneral->setStoredValues($arrValues);
        $settingsOptions->setStoredValues($arrValues);

        return array(
            "settings" =>  $settingsOptions->getArrSettings(),
            "styles" => $settingsGeneral->getArrValues()
        );
    }


    /**
     *
     * get message to admin of the form
     */
    private function getMessageToAdmin() {

        $message = "";

        $emailPrefix = $this->getParam("admin_email_message");
        $emailPrefix = trim($emailPrefix);

        if (!empty($emailPrefix))
            $message .= "{$emailPrefix} <br>\n";

        $arrLabelValue = $this->getArrLabelValue();

        foreach ($arrLabelValue as $label => $value) {

            $value = trim($value);

            if (empty($value))
                $value = "[empty text]";
            else
                $value = "<b> {$value} </b>";

            $message .= "{$label}: $value <br>\n";
        }

        $message = str_replace("::", ":", $message);

        return ($message);
    }


    /**
     * get field by id
     */
    private function getFieldByID($id) {
        $this->validateInited();
        if (empty($id))
            return (null);

        $field = UniteFunctionsForms::getVal($this->arrFields, $id);
        if (empty($field))
            return null;

        return $field;
    }


    /**
     * get field value by id
     */
    private function getFieldValue($id) {
        $field = $this->getFieldByID($id);

        if (empty($field))
            return "";

        $value = UniteFunctionsForms::getVal($field, "value");

        return ($value);
    }


    private function _______________SETTERS_______________() {
    }


    /**
     *
     * delete form from data
     */
    public function deleteFormFromData($data) {
				
        $formID = UniteFunctionsForms::getVal($data, "formID");
        
        UniteFunctionsForms::validateNumeric($formID, "formID");
        UniteFunctionsForms::validateNotEmpty($formID);
        
        $this->db->delete(GlobalsUniteForms::$table_forms, "id={$formID}");
    }


		

        

        


    /**
     * update form title from data
     */
    public function updateTitleFromData($data) {
        $formID = UniteFunctionsForms::getVal($data, "formID");
        $this->initByID($formID);

        $title = UniteFunctionsForms::getVal($data, "title");
        UniteFunctionsForms::validateNotEmpty($title, "Form Title");

        $this->updateField("title", $title);
    }


    /**
     *
     * add form to database
     */
    public function addForm() {

        $operations = new UniteFormsOperations();
        $arrTitles = $operations->getArrFormTitles();
        $counter = 0;
        do {
            $counter++;
            $title = "Form{$counter}";
            $alias = "form{$counter}";
            $titleExists = in_array($title, $arrTitles);
        } while ($titleExists == true);

        $arrFields = array();
        $arrFields["title"] = $title;
        $arrFields["alias"] = $alias;
        $shortcode = "{uniteforms " . $alias . "}";
        
        // add options  - title is a must
        $arrFields["options"] = json_encode(array(
            "form_title" => $title,
            "form_shortcode" => $shortcode
        ));

        // add default general setting ('params')
        $settings = new UniteSettingsForms();
        $settings->loadXMLFile(GlobalsUniteForms::$pathSettings . "general.xml", "general");

        // prepere the settings for addition to the form
        $jsonSettings = json_encode($settings->getArrValues());
        $arrFields["params"] = $jsonSettings;

        $this->db->insert(GlobalsUniteForms::$table_forms, $arrFields);
        $this->initByID($this->db->getLastInsertID());

    }
	
    
    /**
     * check if form exists by title or alias
     */
    private function isFormExists($alias, $title = null){
    	
    	$query = "select * from ".GlobalsUniteForms::$table_forms." where alias = '$alias'";
    	
    	if(!empty($title))
    		$query .= " or title = '$title'";
    	
    	$response = $this->db->fetchSql($query);
    	
    	if(empty($response))
    		return false;
    	else
    		return true;
    }
    
    
    /**
     * duplicate form
     */
    private function duplicateForm(){
		$this->validateInited();
    	$formID = $this->formID;
    	
    	$newTitle = "copy of ".$this->title;
    	$newAlias = "copy_of_".$this->alias;
    	$tableForms = GlobalsUniteForms::$table_forms;
    	
    	$counter = 1;
    	do{
    		$isExists = $this->isFormExists($newAlias, $newTitle);
    		
    		$counter++;
    		
    		if($isExists == true){
	    		$newTitle = "copy{$counter} of ".$this->title;
	    		$newAlias = "copy{$counter}_of_".$this->alias;
    		}
    		
    		//protection against infinate loop
    		if($counter == 20)
    			$isExists = false;
    		
    	}while($isExists == true);
    	
    	$fields_form = GlobalsUniteForms::FIELDS_FORM;
    	
    	$sqlSelect = "select ".$fields_form." from ".GlobalsUniteForms::$table_forms." where id={$formID}";
    	$sqlInsert = "insert into ".GlobalsUniteForms::$table_forms." (".$fields_form.") ($sqlSelect)";
    	$this->db->runSql($sqlInsert);
    	$newFormID = $this->db->getLastInsertID();
    	
    	$arrUpdate = array();
    	$arrUpdate["title"] = $newTitle;
    	$arrUpdate["alias"] = $newAlias;
    	
    	$this->db->update(GlobalsUniteForms::$table_forms, $arrUpdate, "id='{$newFormID}'");
    }

    
    /**
     * duplicate form from data
     */
    public function duplicateFormFromData($data){
    	
    	$formID = UniteFunctionsForms::getVal($data, "formID");
    	$this->initByID($formID);
    	
    	$this->duplicateForm();
    }
    
    
    /**
     * modify save input of the messages
     */
    private function modifyMessagesInput($arrMess) {

        if (gettype($arrMess) == "object")
            $arrMess = (array)$arrMess;

        if (gettype($arrMess) != "array")
            return (array());

        //modify border
        if (array_key_exists("border", $arrMess)) {
            $arrBorder = $arrMess["border"];
            $arrMess["borderType"] = UniteFunctionsForms::getVal($arrBorder, "style");
            $arrMess["borderWidth"] = UniteFunctionsForms::getVal($arrBorder, "width");
            $arrMess["borderColor"] = UniteFunctionsForms::getVal($arrBorder, "color");
            unset($arrMess["border"]);
        }

        //modify shadow
        if (array_key_exists("textShadow", $arrMess)) {
            $arrShadow = $arrMess["textShadow"];
            $arrMess["shadowColor"] = UniteFunctionsForms::getVal($arrShadow, "color");
            $arrMess["shadowH"] = UniteFunctionsForms::getVal($arrShadow, "horz");
            $arrMess["shadowV"] = UniteFunctionsForms::getVal($arrShadow, "vert");
            $arrMess["shadowB"] = UniteFunctionsForms::getVal($arrShadow, "blur");

            unset($arrMess["textShadow"]);
        }

        //modify box shadow
        if (array_key_exists("shadow", $arrMess)) {

            $arrShadow = $arrMess["shadow"];

            $arrMess["shadowColor"] = UniteFunctionsForms::getVal($arrShadow, "color");
            $arrMess["shadowH"] = UniteFunctionsForms::getVal($arrShadow, "horz");
            $arrMess["shadowV"] = UniteFunctionsForms::getVal($arrShadow, "vert");
            $arrMess["shadowB"] = UniteFunctionsForms::getVal($arrShadow, "blur");

            if (array_key_exists("inset", $arrShadow)) {
                $inset = UniteFunctionsForms::getVal($arrShadow, "inset");
                $inset = UniteFunctionsForms::strToBool($inset);
                $arrMess["shadowInset"] = $inset;
            }

            unset($arrMess["shadow"]);
        }


        //modify padding
        if (array_key_exists("padding", $arrMess)) {
            $arrPadding = $arrMess["padding"];
            $arrMess["paddingTop"] = UniteFunctionsForms::getVal($arrPadding, "top");
            $arrMess["paddingBottom"] = UniteFunctionsForms::getVal($arrPadding, "bottom");
            $arrMess["paddingLeft"] = UniteFunctionsForms::getVal($arrPadding, "left");
            $arrMess["paddingRight"] = UniteFunctionsForms::getVal($arrPadding, "right");

            unset($arrMess["padding"]);
        }

        //modify margin
        if (array_key_exists("margin", $arrMess)) {
            $arrMargin = $arrMess["margin"];
            $arrMess["marginTop"] = UniteFunctionsForms::getVal($arrMargin, "top");
            $arrMess["marginBottom"] = UniteFunctionsForms::getVal($arrMargin, "bottom");
            $arrMess["marginLeft"] = UniteFunctionsForms::getVal($arrMargin, "left");
            $arrMess["marginRight"] = UniteFunctionsForms::getVal($arrMargin, "right");

            unset($arrMess["margin"]);
        }

        //modify backround
        if (array_key_exists("bg", $arrMess)) {
            $arrBG = $arrMess["bg"];
            $arrMess["bgType"] = UniteFunctionsForms::getVal($arrBG, "type");
            $arrMess["bgStartColor"] = UniteFunctionsForms::getVal($arrBG, "c1");

            if (array_key_exists("c2", $arrBG))
                $arrMess["bgEndColor"] = UniteFunctionsForms::getVal($arrBG, "c2");

            unset($arrMess["bg"]);
        }


        return ($arrMess);
    }


    /**
     *
     * modify save visual settings
     */
    private function modifySaveVisualSettings($settings) {

        $loadMess = UniteFunctionsForms::getVal($settings, "loadmess");
        $settings["loadmess"] = $this->modifyMessagesInput($loadMess);

        $errMess = UniteFunctionsForms::getVal($settings, "errmess");
        $settings["errmess"] = $this->modifyMessagesInput($errMess);

        $succMess = UniteFunctionsForms::getVal($settings, "succmess");
        $settings["succmess"] = $this->modifyMessagesInput($succMess);

        return ($settings);
    }


    /**
     *
     * update common settings from data
     */
    public function updateVisualSettingsFromData($data) {

        $formID = UniteFunctionsForms::getVal($data, "formID");
        $this->initByID($formID);

        $styles = UniteFunctionsForms::getVal($data, "styles");
        $styles = $this->modifySaveVisualSettings($styles);
        $styles = $this->getMergedParams($styles);

        $settings = UniteFunctionsForms::getVal($data, "settings");
        
        
        $fields = UniteFunctionsForms::getVal($data, "fields");
        
        $arrUpdate = array(
            "params" => json_encode($styles),
            "fields" => json_encode($fields),
            "options" => json_encode($settings),
            "title" => $settings['form_title'],
            "alias" => $settings['form_alias']
        );
        $this->updateFields($arrUpdate);
    }

    
    /**
     * export form from data
     * @param $data
     */
    public function exportFromData($data){
    	$formID = UniteFunctionsForms::getVal($data, "formID");
    	$this->initByID($formID);
    	
    	$arrExport = $this->record;
    	unset($arrExport["id"]);
    	
    	$strExport = serialize($arrExport);
    	
    	$filename = $this->alias."_export.txt";
    	UniteFunctionsForms::downloadFile($strExport, $filename);
    }
    
    
    /**
     * import form from data
     * 
     */
    public function importFromData($data){
    	
    	$formID = UniteFunctionsForms::getVal($data, "formID");
    	$this->initByID($formID);
    	
    	$filepath = @$_FILES["data"]["tmp_name"]["file"];
    	if(empty($filepath))
    		UniteFunctionsForms::throwError("Export file not found!");
    	
    	$content = @file_get_contents($filepath);
    	
    	if(empty($content))
    		UniteFunctionsForms::throwError("Can't get export file content!");
    		
    	$arrImport = @unserialize($content);
    	if(empty($arrImport))
    		UniteFunctionsForms::throwError("Cannot open the saved content!");

    	$this->updateFields($arrImport);
    	
    }
    
    
    /**
     *
     * update form fields in db
     * @param $arrUpdate
     */
    private function updateFields($arrUpdate) {
        $this->validateInited();
        
        $this->db->update(GlobalsUniteForms::$table_forms, $arrUpdate, "id='".$this->formID."'");
    }


    /**
     *
     * update some field in form db
     * @param $fieldName
     * @param $fieldValue
     * @throws Exception
     */
    private function updateField($fieldName, $fieldValue) {
        if (is_array($fieldValue) || is_object($fieldValue))
            UniteFunctionsForms::throwError("The value should be string or number only, not array or object to update.");

        $arrUpdate = array();
        $arrUpdate[$fieldName] = $fieldValue;
        $this->updateFields($arrUpdate);
    }

    /**
     *
     * save record before sending
     */
    public function saveRecord() {

        //need to rewrite this function
        
    	return (false);
    }


}

?>