<?php

/**
 * @package Unite Forms for Joomla 1.7-3.5
 * @author UniteCMS.net
 * @copyright (C) 2014 Unite CMS, All Rights Reserved.
 * @license GNU/GPLv3 http://www.gnu.org/licenses/gpl-3.0.html
 * */

defined('_JEXEC') or die;


class UniteFormsOutput extends UniteFormsBase {

    private $data = null;
    private $formID;
    private $formID_html;
    private $formID_form;

    const FORM_TYPE_RADIO = "radio";
    const FORM_TYPE_CHECKBOX = "checkbox";
    const FORM_TYPE_SELECT = "select";
    const FORM_TYPE_TEXT = "text";
    const FORM_TYPE_AREA = "textarea";
    const FORM_TYPE_TITLE = "title";
    const FORM_TYPE_PARAGRAPH = "paragraph";
    const FORM_TYPE_CAPTCHA = "captcha";
    const FORM_TYPE_ERRROR_MESSAGE = 'errmess';
    const FORM_TYPE_SUCCESS_MESSAGE = 'succmess';
    const FORM_TYPE_LOADING_MESSAGE = 'loadmess';
    const FORM_TYPE_BUTTON = 'button';
    const FORM_TYPE_IMAGE = 'image';
    const FORM_TYPE_FILE = 'file';

    /**
     *
     * put error message
     */
    private function putErrorMessage($message, $trace = "") {
        ?>
        <div style="width:800px;height:300px;margin-bottom:10px;border:1px solid black;overflow:auto;">
            <div style="padding-top:40px;color:red;font-size:16px;text-align:center;">
                Unite Forms Error: <?php echo $message ?>
            </div>
            <br>
            <?php
            if (!empty($trace))
                dmp($trace);
            ?>
        </div>

        <?php
    }


    /**
     *
     * validate that both parameters are inited
     */
    private function validateInited() {

        $message = "The form output not inited, plaese check the code";

        if ($this->params === null)
            UniteFunctionsForms::throwError($message);

        if ($this->data === null)
            UniteFunctionsForms::throwError($message);

        //empty data validation:
        if (empty($this->data))
            UniteFunctionsForms::throwError("The form is empty, please add some fields");

    }

    /**
     *
     * validate field type
     */
    private function validateType($type) {
        switch ($type) {
            case self::FORM_TYPE_AREA:
            case self::FORM_TYPE_RADIO:
            case self::FORM_TYPE_CHECKBOX:
            case self::FORM_TYPE_SELECT:
            case self::FORM_TYPE_TEXT:
            case self::FORM_TYPE_TITLE:
            case self::FORM_TYPE_PARAGRAPH:
            case self::FORM_TYPE_ERRROR_MESSAGE:
            case self::FORM_TYPE_SUCCESS_MESSAGE:
            case self::FORM_TYPE_LOADING_MESSAGE:
            case self::FORM_TYPE_CAPTCHA:
            case self::FORM_TYPE_BUTTON:
            case self::FORM_TYPE_IMAGE:
            case self::FORM_TYPE_FILE:
                return (true);
                break;
        }
        UniteFunctionsForms::throwError("Unknown field type: $type");
    }

    /**
     *
     * init the output
     */
    public function init($formID, $params, $data) {

        $this->params = $params;

        $this->formID = $formID;
        $this->formID_html = "uniteform_" . $this->formID . "_form";
        $this->formID_form = $this->formID_html . "_form";

        //remove button and messages from data
        $hasButton = false;
        $tempData = $data;
        $extraParams = array();
        foreach ($data as $index => $field) {
            $flag = true; // we flag if to add field as normal - if it isnt a button or a message
            $type = UniteFunctionsForms::getVal($field, "type");

            switch ($type) {
                case "loadmess":
                case "errmess":
                case "succmess":
                    $flag = false;
                    $extraParams[$type] = $data[$index];
                    unset($data[$index]);
                    unset($tempData[$index]);
	            break;
            }

            if ($flag == true) {
                $field = UniteFunctionsForms::convertStdClassToArray($field);
                $data[$index] = $field;
                $tempData[$index] = $field;
            }

        }

        $this->params = array_merge($this->params, $extraParams);
        $this->data = $tempData;

    }


    /**
     *
     * get params
     */
    public function getParams() {

        return ($this->params);
    }


//    /**
//     *
//     * process send button values, add them to general params.
//     * @param $arrButton
//     */
//    private function processSendButtonValues($arrButton) {
//        foreach ($arrButton as $key => $value) {
//            if ($key == "type")
//                continue;
//            $paramKey = "sendbutton_" . $key;
//            $this->params[$paramKey] = $value;
//        }
//
//    }


    /**
     *
     * output the forms
     */
    public function outputForm() {
    	
        try {

        	$this->validateInited();
            $this->putBase();
        
        } catch (Exception $e) {
            $message = $e->getMessage();
			
            $trace = "";
            if (GlobalsUniteForms::SHOW_TRACE == true)
                $trace = $e->getTraceAsString();

            $this->putErrorMessage($message, $trace);
        }
    }

    function x____________GET_CSS_STRING________() {
    }

    /**
     *
     * get border css
     * type can be form / field / sendbutton
     */
    private function getCssBorder($type = "form", $arrBorder = "", $labelType = null) {
        $css = "";
        switch ($type) {
            case "form":
                $borderType = $this->getParam("formBorderType", "solid", self::MODE_VALIDATE_EXISTS);
                $borderWidth = $this->getParam("formBorderWidth", "4", self::MODE_VALIDATE_NUMERIC);
                $borderColor = $this->getParam("formBorderColor", "#802323");
                $borderRadius = $this->getParam("formBorderRadius", "12", self::MODE_VALIDATE_NUMERIC);
                break;
            case "field":
                $borderType = $this->getParam("fieldBorderType", "solid", self::MODE_VALIDATE_EXISTS);
                $borderWidth = $this->getParam("fieldBorderSize", "2", self::MODE_VALIDATE_NUMERIC);
                $borderColor = $this->getParam("fieldBorderColor", "#3c33eb");
                $borderRadius = $this->getParam("fieldBorderRadius", "5", self::MODE_VALIDATE_NUMERIC);
                break;
            case "title":
                $borderType = $this->getParam("titleBorderType", "solid", self::MODE_VALIDATE_EXISTS);
                $borderWidth = $this->getParam("titleBorderSize", "2", self::MODE_VALIDATE_NUMERIC);
                $borderColor = $this->getParam("titleBorderColor", "#3c33eb");
                $borderRadius = $this->getParam("titleBorderRadius", "5", self::MODE_VALIDATE_NUMERIC);
                break;
            case "description":
                $borderType = $this->getParam("descriptionBorderType", "solid", self::MODE_VALIDATE_EXISTS);
                $borderWidth = $this->getParam("descriptionBorderSize", "2", self::MODE_VALIDATE_NUMERIC);
                $borderColor = $this->getParam("descriptionBorderColor", "#3c33eb");
                $borderRadius = $this->getParam("descriptionBorderRadius", "5", self::MODE_VALIDATE_NUMERIC);
                break;
            case "button":
                $borderType = $this->getParam("buttonBorderType", "solid", self::MODE_VALIDATE_EXISTS);
                $borderWidth = $this->getParam("buttonBorderSize", "1", self::MODE_VALIDATE_NUMERIC);
                $borderColor = $this->getParam("buttonBorderColor", "#000000");
                $borderRadius = $this->getParam("buttonBorderRadius", "6", self::MODE_VALIDATE_NUMERIC);
                break;
            case "override":
                if (empty($arrBorder))
                    return (false);
                $borderType = $this->getParam("style", "solid", self::MODE_VALIDATE_EXISTS, $arrBorder);
                $borderWidth = $this->getParam("width", "2", self::MODE_VALIDATE_NUMERIC, $arrBorder);
                $borderColor = $this->getParam("color", "#3c33eb", "", $arrBorder);
                $borderRadius = $this->getParam("radius", "0", self::MODE_FORCE_NUMERIC, $arrBorder);
                break;
            case "message":
                $mess = (array)$this->getParam($labelType);

                $borderType = $this->getParam("borderStyle", "none", '', $mess);
                $borderWidth = $this->getParam("borderWidth", "2", self::MODE_VALIDATE_NUMERIC, $mess);
                $borderColor = $this->getParam("borderColor", "#3c33eb", self::MODE_FORCE_HEX, $mess);
                $borderRadius = $this->getParam("borderRadius", "0", self::MODE_FORCE_NUMERIC, $mess);
                break;
            default:
                UniteFunctionsForms::throwError("Wrong get border type: $type");
                break;
        }

        if ($borderWidth == 0)
            $borderType = "none";

        switch ($borderType) {
            case "none":
                $css = "border: none !important;";
                return ($css);
                break;
            default:
            case "solid":
                $css = "border:{$borderWidth}px solid {$borderColor} !important;";
                break;
            case "dashed":
                $css = "border:{$borderWidth}px dashed {$borderColor} !important;";
                break;
            case "dotted":
                $css = "border:{$borderWidth}px dotted {$borderColor} !important;";
                break;
            case "rounded":
                $css = "border: medium none !important;";
                break;
        }

        $css .= "border-radius:{$borderRadius}px !important;";

        return ($css);
    }


    /**
     *
     * get background css
     * type = form / field / sendbutton / override
     * @param string $type
     * @param null $arrBG
     * @param null $labelType
     * @return string
     * @throws Exception
     */
    private function getCssBackground($type = "form", $arrBG = null, $labelType = null) {

        $css = "";
        switch ($type) {
            case "form":
                $bgType = $this->getParam("formBgType", "gradient");
                $startColor = $this->getParam("formBgStartColor", "#7566D6");
                $endColor = $this->getParam("formBgEndColor", "#FCFCFD");
                $bgImg = $this->getParam("formBgImg");
                $bgFit = $this->getParam("formBgFit");
                $bgRepeat = $this->getParam("formBgRepeat");
                $bgPosition = $this->getParam("formBgPosition");
                break;
            case "field":
                $bgType = $this->getParam("fieldBgType", "gradient");
                $startColor = $this->getParam("fieldBgStartColor", "#7566d6");
                $endColor = $this->getParam("fieldBgEndColor", "#fcfcfd");
                $bgImg = $this->getParam("fieldBgImg");
                $bgFit = $this->getParam("fieldBgFit");
                $bgRepeat = $this->getParam("fieldBgRepeat");
                $bgPosition = $this->getParam("fieldBgPosition");
                break;
            case "description":
                $bgType = $this->getParam("descriptionBackgroundType", "gradient");
                $color = $this->getParam("descriptionBackgroundColor", "#7566d6");
                $startColor = $this->getParam("descriptionBackgroundStartColor", "#7566d6");
                $endColor = $this->getParam("descriptionBackgroundEndColor", "#fcfcfd");
                $bgImg = $this->getParam("descriptionBackgroundImg");
                $bgFit = $this->getParam("descriptionBackgroundFit");
                $bgRepeat = $this->getParam("descriptionBackgroundRepeat");
                $bgPosition = $this->getParam("descriptionBackgroundPosition");
                break;
            case "title":
                $bgType = $this->getParam("titleBackgroundType", "gradient");
                $color = $this->getParam("titleBackgroundColor", "#7566d6");
                $startColor = $this->getParam("titleBackgroundStartColor", "#7566d6");
                $endColor = $this->getParam("titleBackgroundEndColor", "#fcfcfd");
                $bgImg = $this->getParam("titleBackgroundImg");
                $bgFit = $this->getParam("titleBackgroundFit");
                $bgRepeat = $this->getParam("titleBackgroundRepeat");
                $bgPosition = $this->getParam("titleBackgroundPosition");
                break;
            case "button":
                $bgType = $this->getParam("buttonBackgroundType", "gradient");
                $color = $this->getParam("buttonBackgroundColor", "#0088CC");
                $startColor = $this->getParam("buttonBackgroundStartColor", "#0088CC");
                $endColor = $this->getParam("buttonBackgroundEndColor", "#0044CC");
                $bgImg = $this->getParam("buttonBackgroundImg", "");
                $bgFit = $this->getParam("buttonBackgroundFit");
                $bgRepeat = $this->getParam("buttonBackgroundRepeat");
                $bgPosition = $this->getParam("buttonBackgroundPosition");
                break;
            case "override":
                $bgType = $this->getParam("bgType", "none", null, $arrBG);
                $startColor = $this->getParam("bgStartColor", null, null, $arrBG);
                $endColor = $this->getParam("bgEndColor", null, null, $arrBG);
                $bgImg = $this->getParam("bgImg", null, null, $arrBG);
                $bgFit = $this->getParam("bgFit", null, null, $arrBG);
                $bgRepeat = $this->getParam("bgRepeat", null, null, $arrBG);
                $bgPosition = $this->getParam("bgPosition", null, null, $arrBG);
                break;
            case "message":
                $mess = (array)$this->getParam($labelType);
                $bgType = $this->getParam('bgType', 'none', '', $mess);
                $startColor = $this->getParam('bgStartColor', '#000', self::MODE_FORCE_HEX, $mess);
                $endColor = $this->getParam('bgEndColor', '#fff', self::MODE_FORCE_HEX, $mess);
                $bgImg = $this->getParam("bgImg", null, null, $mess);
                $bgFit = $this->getParam("bgFit", null, null, $mess);
                $bgRepeat = $this->getParam("bgRepeat", null, null, $mess);
                $bgPosition = $this->getParam("bgPosition", null, null, $mess);
                break;
            default:
                UniteFunctionsForms::throwError("Wrong background type: $type");
                break;
        }

        switch ($bgType) {
            default:
            case "gradient":
                $css = "background: linear-gradient(to bottom, {$startColor}, {$endColor}) repeat scroll 0% 0% transparent !important;";
                break;
            case "none":
                $css = "background: none !important;";
                break;
            case "img":
                $startColor = isset($color) ? $color : $startColor;
                $css = "background: {$startColor} url('{$bgImg}') {$bgPosition}/{$bgFit} {$bgRepeat} !important;";
                break;
            case "solid":
                $startColor = isset($color) ? $color : $startColor;
                $css = "background: none repeat scroll 0% 0% {$startColor} !important;";
                break;
        }

        return ($css);
    }


    /**
     *
     * get font css
     * @param string $type
     * @param string $arrParams
     * @return string
     * @throws Exception
     */
    private function getCssFont($type = "button", $arrParams = "") {
        $css = "";

        switch ($type) {
            case "button":
                $color = $this->getParam("buttonColor", "#000000");
                $size = $this->getParam("buttonFontSize", "20", self::MODE_FORCE_NUMERIC);
                $weight = $this->getParam("buttonFontWeight", "normal");
                break;
            case "title":
                $color = $this->getParam("titleColor", "#000000");
                $size = $this->getParam("titleFontSize", "20", self::MODE_FORCE_NUMERIC);
                break;
            case "description":
                $color = $this->getParam("descriptionColor", "#000000");
                $size = $this->getParam("descriptionFontSize", "20", self::MODE_FORCE_NUMERIC);
                break;
            case "override":
                $color = $this->getParam("color", "", "", $arrParams);
                $size = $this->getParam("fontSize", "", self::MODE_FORCE_NUMERIC, $arrParams);
                $weight = $this->getParam("fontWeight", "normal", "", $arrParams);
                break;
            default:
                UniteFunctionsForms::throwError("The type: $type don't exist.");
                break;
        }

        if (!empty($color))
            $css .= "color:$color !important;";

        if (!empty($size))
            $css .= "font-size:{$size}px !important;";

        if (!empty($weight))
            $css .= "font-weight:{$weight} !important;";

        return ($css);
    }


    /**
     *
     * get css of field textshaddow
     */
    private function getCssTextShadow($field) {

        $horz = $this->getParam("shadowH", 0, self::MODE_FORCE_NUMERIC, $field);
        $vert = $this->getParam("shadowV", 0, self::MODE_FORCE_NUMERIC, $field);
        $blur = $this->getParam("shadowBlur", 0, self::MODE_FORCE_NUMERIC, $field);			
        $color = UniteFunctionsForms::getVal($field, "shadowColor", "#000000");
        
        if($horz == 0 && $vert == 0 && $blur == 0)
        	$css = " text-shadow:none !important;";
        else
           $css = " text-shadow: {$horz}px {$vert}px {$blur}px {$color} !important;";

        return ($css);
    }


    /**
     *
     * get css box shadow
     */
    private function getCssBoxShadow($field, $isLabel = false) {

        if ($isLabel) {
            $mess = (array)$this->getParam($field);
            $arrShadow = (array_key_exists('shadow', $mess) ? (array)$mess['shadow'] : array());

        } else {
            $arrShadow = UniteFunctionsForms::getVal($field, "shadow");
        }


        if (empty($arrShadow))
            return ("");

        $horz = $this->getParam("shadowHorz", 0, self::MODE_FORCE_NUMERIC);
        $vert = $this->getParam("shadowVert", 0, self::MODE_FORCE_NUMERIC);
        $blur = $this->getParam("shadowBlur", 0, self::MODE_FORCE_NUMERIC);
        $color = UniteFunctionsForms::getVal($mess, "shadowColor", "#000000");
        $isInset = $this->getParam("shadowInset", false, self::MODE_FORCE_BOOLEAN);
        $strInset = ($isInset ? " inset" : "");

        $css = " box-shadow: {$horz}px {$vert}px {$blur}px {$color}{$strInset} !important;";

        return ($css);
    }

    /**
     * get padding or margin of messages css
     */
    private function getCssMessagesPaddingMargin($arr, $type) {

        $top = $this->getParam($type . "Top", 0, self::MODE_FORCE_NUMERIC, $arr);
        $bottom = $this->getParam($type . "Bottom", 0, self::MODE_FORCE_NUMERIC, $arr);
        $left = $this->getParam($type . "Left", 0, self::MODE_FORCE_NUMERIC, $arr);
        $right = $this->getParam($type . "Right", 0, self::MODE_FORCE_NUMERIC, $arr);

        $css = " $type:{$top}px {$right}px {$bottom}px {$left}px !important;";

        return ($css);
    }

    /**
     * get padding or margin of messages css
     */
    private function getCssFontStyles($arr) {
        $fontWeight = $this->getParam("bold", false, self::MODE_FORCE_BOOLEAN, $arr) ? "bold" : "normal";
        $fontStyle = $this->getParam("italic", false, self::MODE_FORCE_BOOLEAN, $arr) ? "italic" : "initial";
        $textDecoration = $this->getParam("underline", false, self::MODE_FORCE_BOOLEAN, $arr) ? "underline" : "initial";

        $css = "font-weight: {$fontWeight} !important;";
        $css .= "font-style: {$fontStyle} !important;";
        $css .= "text-decoration: {$textDecoration} !important;";

        return ($css);
    }
    /**
     *
     * get padding css
     */
    private function getCssPaddingMargin($prefix, $itemName = "padding") {
        $itemNameCap = ucfirst($itemName);

        $top = $this->getParam("{$prefix}{$itemNameCap}Top", 0, self::MODE_FORCE_NUMERIC);
        $bottom = $this->getParam("{$prefix}{$itemNameCap}Bottom", 0, self::MODE_FORCE_NUMERIC);
        $left = $this->getParam("{$prefix}{$itemNameCap}Left", 0, self::MODE_FORCE_NUMERIC);
        $right = $this->getParam("{$prefix}{$itemNameCap}Right", 0, self::MODE_FORCE_NUMERIC);

        $css = " $itemName:{$top}px {$right}px {$bottom}px {$left}px !important;";

        return ($css);
    }


    /**
     *
     * get css general
     */
    private function getCssGeneral() {

        $maxWidth = $this->getParam("formFullWidth", "false", self::MODE_FORCE_BOOLEAN) ? "100%" : $this->getParam("formMaxWidth", "900");
        $minWidth = $this->getParam("formMinWidth", "900");
        $shadowColor = $this->getParam('formShadowColor', 'FFF', self::MODE_VALIDATE_EXISTS);
        $shadowH = $this->getParam('formShadowH', '0', self::MODE_FORCE_NUMERIC);
        $shadowV = $this->getParam('formShadowV', '0', self::MODE_FORCE_NUMERIC);
        $shadowBlur = $this->getParam('formShadowB', '0', self::MODE_FORCE_NUMERIC);

        $css = "max-width:{$maxWidth};";
        $css .= "min-width:{$minWidth};";
        $css .= "box-shadow:{$shadowH}px {$shadowV}px {$shadowBlur}px {$shadowColor};";
        $css .= $this->getCssPaddingMargin("form", "padding");
        return ($css);
    }

    /**
     *
     * get general textbox related css
     */
    private function getCssTextbox() {

        $width = $this->getParam("fieldWidth", "300", self::MODE_WIDTH_FIELD);

        $css = "";
        $css .= "width:{$width} !important;";
        return ($css);
    }


    /**
     *
     * get general textbox related css
     */
    private function getCssTextArea() {

        $width = $this->getParam("fieldAreaWidth", "400", self::MODE_WIDTH_FIELD);
        $height = $this->getParam("fieldAreaHeight", "80", self::MODE_WIDTH_FIELD);

        $css = "";
        $css .= "width:{$width} !important;height:{$height}px !important";
        return ($css);
    }


    /**
     *
     * get label css
     */
    private function getCssLabel() {
        $color = $this->getParam("labelFieldColor", "#cc0f50");
        $fontSize = $this->getParam("labelFontSize", "20", self::MODE_VALIDATE_NUMERIC);
        $labelAlign = $this->getParam("labelAlign", "top");
        $labelWidth = $this->getParam("labelWidth", "190", self::MODE_WIDTH_FIELD);
        $labelMargin = $this->getParam("labelMargin", "5", self::MODE_VALIDATE_NUMERIC);

        $css = " font-size:{$fontSize}px;color:{$color} !important;width:{$labelWidth}!important;";
        switch ($labelAlign) {
            case "left":
                $css .= "float:left;";
                break;
            case "in":
                $css .= "margin-left:{$labelMargin}px!important;position: absolute;top: 0;left: 0;overflow: hidden;display: inline-block;white-space: nowrap;";
                break;
            default:
                $css .= "margin-bottom:{$labelMargin}px!important;";
        }
        $css .= $this->getCssFontStyles($this->getParam("labelFontStyle"));
        return ($css);
    }

    
    /**
     * get textarea label
     */
    private function getCssTextAreaLabel() {
        $css = "";
        if ($this->getParam("labelAlign", "top") == "in") {
            $labelMargin = $this->getParam("labelMargin", "5", self::MODE_VALIDATE_NUMERIC);
            $css = "margin-top:{$labelMargin}px !important";
        }
        return $css;
    }

    
    /**
     *
     * get field wrapper css
     */
    private function getCssSap() {
        $css = "";
        $heightBetweenLines = $this->getParam("formLineHeight", "23", self::MODE_FORCE_NUMERIC);
        $css .= "margin-top: {$heightBetweenLines}px";

        return ($css);
    }


    /**
     *
     * get general css of the fields
     */
    private function getCssFields() {

        $textColor = $this->getParam("fieldTextColor", "#000000");

        $fontSize = $this->getParam("fieldFontSize", "19", self::MODE_VALIDATE_NUMERIC);
        $cssBackground = $this->getCssBackground("field");
        $cssBorder = $this->getCssBorder("field");

        $fieldwidth = $this->getParam('fieldWidth', '0', self::MODE_WIDTH_FIELD);
        $shadowColor = $this->getParam('fieldBoxShadowColor', 'FFF', self::MODE_FORCE_HEX);
        $shadowH = $this->getParam('fieldBoxShadowH', '0', self::MODE_FORCE_NUMERIC);
        $shadowV = $this->getParam('fieldBoxShadowV', '0', self::MODE_FORCE_NUMERIC);
        $shadowBlur = $this->getParam('fieldBoxShadowBlur', '0', self::MODE_FORCE_NUMERIC);
        $shadowInset = $this->getParam('fieldBoxShadowInset', 'false', self::MODE_FORCE_BOOLEAN) ? "inset" : "";

        //make the css
        $css = "\n";
        $css .= "\t color:{$textColor} !important;font-size:{$fontSize}px !important;\n";
        $css .= "\t box-shadow: {$shadowInset} {$shadowH}px {$shadowV}px {$shadowBlur}px {$shadowColor} !important;\n";
        $css .= "\t" . $cssBackground . "\n";
        $css .= "\t" . $cssBorder . "\n";
        $css .= "\t width:{$fieldwidth}; \n";
        $css .= $this->getCssFontStyles($this->getParam("fieldFontStyle"));
        $css .= $this->getCssPaddingMargin("field", "padding");
        return ($css);
    }


    /**
     *
     * get css that affect radio and checkbox labels
     */
    private function getCssRadioCheckboxLabel() {
        $fontSize = $this->getParam("fieldFontSize", "19", self::MODE_VALIDATE_NUMERIC);
        $textColor = $this->getParam("fieldTextColor", "#000000");
        //make the css
        $css = "\n";
        $css .= "\t color:{$textColor};font-size:{$fontSize}px !important;\n";
        return ($css);
    }

    /**
     *
     * put send button css
     */
    private function getCssSendButton() {
        $marginTop = $this->getParam("buttonMarginTop", "0", self::MODE_FORCE_NUMERIC);
        $marginBottom = $this->getParam("buttonMarginBottom", "0", self::MODE_FORCE_NUMERIC);

        if ($this->params['formDirection'] === "rtl") {
            $marginRight = $this->getParam("buttonMarginSide", "0", self::MODE_FORCE_NUMERIC);
            $marginLeft = 0;
        } else {
            $marginRight = 0;
            $marginLeft = $this->getParam("buttonMarginSide", "0", self::MODE_FORCE_NUMERIC);
        }

        $buttonBoxShadowColor = $this->getParam("buttonBoxShadowColor");
        $buttonBoxShadowH = $this->getParam("buttonBoxShadowH");
        $buttonBoxShadowV = $this->getParam("buttonBoxShadowV");
        $buttonBoxShadowBlur = $this->getParam("buttonBoxShadowBlur");
        $isInset = $this->getParam("buttonBoxShadowInset", false, self::MODE_FORCE_BOOLEAN);
        $strInset = ($isInset ? "inset" : "");
        $cssBoxShadow = "box-shadow: {$strInset} {$buttonBoxShadowH}px {$buttonBoxShadowV}px {$buttonBoxShadowBlur}px {$buttonBoxShadowColor} !important;";

        $float = $this->getParam("buttonFloat", "left");

        $cssBackground = $this->getCssBackground("button");
        $cssBorder = $this->getCssBorder("button");
        $cssFont = $this->getCssFont("button");

        $css = "\n";
        $css .= "\t margin:{$marginTop}px {$marginRight}px {$marginBottom}px {$marginLeft}px !important;\n";
        $css .= "\t float:{$float}; \n";
        $css .= "\t {$cssBackground} \n";
        $css .= "\t {$cssBorder} \n";
        $css .= "\t {$cssFont} \n";
        $css .= "\t {$cssBoxShadow} \n";
        $css .= $this->getCssFontStyles($this->getParam("buttonFontStyle"));
        $css .= $this->getCssPaddingMargin("button", "padding");
        return ($css);
    }


    /**
     *
     * get label css
     */
    private function getCssMessages($label) {

        // init some stuff
    	$param = $this->getParam($label);
    	if(empty($param))
    		return("");
    	
    	
        $css = '';
        
        //prepare vars
        $fontSize = UniteFunctionsForms::getVal($param, "fontSize", 14);

        $color = (array_key_exists('color', $param) ?
            $this->getParam("color", "#fff", self::MODE_FORCE_HEX, array('color' => $param['color'])) : '#fff');

        $textAlign = (array_key_exists('textAlign', $param) ?
            $this->getParam("textAlign", "left", '', array('textAlign' => $param['textAlign']))
            : 'left');

        $width = (array_key_exists('width', $param) ?
            $this->getParam("width", "400PX", '', array('width' => $param['width']))
            : '400px');

        // add 'simple' css
        $css .= "color: {$color} !important; ";
        $css .= "font-size: {$fontSize}PX !important; ";
        $css .= "text-align: {$textAlign} !important; ";
        $css .= "width: {$width} !important; ";

        //add 'complex' css
        $css .= ' ' . $this->getCssBackground('message', array(), $label);    // add bg
        $css .= ' ' . $this->getCssborder('message', array(), $label);        // add border
        $css .= ' ' . $this->getCssMessagesPaddingMargin($param, 'padding');    // add padding
        $css .= ' ' . $this->getCssMessagesPaddingMargin($param, 'margin');        // add margin
        $css .= ' ' . $this->getCssBoxShadow($label, 'margin', true);        // add margin
        $css .= ' ' . $this->getCssTextShadow($param);
        $css .= $this->getCssFontStyles($this->getParam("messageFontStyle"));
        return $css;
    }

    function x____________OTHER_FUNCTIONS________() {
    }

    /**
     *
     * get field override css
     */
    private function getFieldOverrideCss($field) {

        $cssFormID = "#" . $this->formID_html;

        $css = "";

        $type = UniteFunctionsForms::getVal($field, "type");
        $id = UniteFunctionsForms::getVal($field, "id");

        $css .= "{$cssFormID} #{$id}" . "{";

        //set backguond
        $cssBackground = $this->getCssBackground("override", $field);
        if (!empty($cssBackground))
            $css .= $cssBackground;

        //set width
        $width = UniteFunctionsForms::getVal($field, "width");

        if (!empty($width)) {
            $width = $this->getParam("width", "", self::MODE_WIDTH_FIELD, $field);
            $css .= " width:{$width}!important;";
        }


        $css .= "}";

        return ($css);
    }

    /**
     *
     * get override css of the field caption
     * TODO: finish this function
     */
    private function getFieldCaptionOverrideCss($field) {

        return ("");
    }


    /**
     *
     * get caption field override css
     * @param $field
     * @return string
     */
    private function getFieldTitleOverrideCss($field) {

        $cssFormID = "#" . $this->formID_html;

        $css = "";

        $id = UniteFunctionsForms::getVal($field, "id");

        $css .= "{$cssFormID} #uf_field_wrapper_{$id} .uf-field-label" . "{";
        $css .= "font-weight: bold !important;";

        $titleTextShadowColor = $this->getParam("titleTextShadowColor");
        $titleTextShadowH = $this->getParam("titleTextShadowH");
        $titleTextShadowV = $this->getParam("titleTextShadowV");
        $titleTextShadowBlur = $this->getParam("titleTextShadowBlur");
        $css .= "text-shadow: {$titleTextShadowH}px {$titleTextShadowV}px {$titleTextShadowBlur}px {$titleTextShadowColor} !important;";

        $titleBoxShadowColor = $this->getParam("titleBoxShadowColor");
        $titleBoxShadowH = $this->getParam("titleBoxShadowH");
        $titleBoxShadowV = $this->getParam("titleBoxShadowV");
        $titleBoxShadowBlur = $this->getParam("titleBoxShadowBlur");
        $isInset = $this->getParam("titleBoxShadowInset", false, self::MODE_FORCE_BOOLEAN);
        $strInset = ($isInset ? "inset" : "");
        $css .= "box-shadow: {$strInset} {$titleBoxShadowH}px {$titleBoxShadowV}px {$titleBoxShadowBlur}px {$titleBoxShadowColor} !important;";

        //set background
        $cssBG = $this->getCssBackground("title");
        $css .= $cssBG;

        //set border
        $cssBorder = $this->getCssBorder("title");
        $css .= $cssBorder;

        $width = $this->getParam("titleWidth");
        if (!empty($width))
            $css .= "width: {$width} !important;";

        $cssFont = $this->getCssFont("title");
        if (!empty($cssFont))
            $css .= $cssFont;

        $align = $this->getParam("titleAlign");
        if (!empty($align))
            $css .= " text-align:{$align}!important;";
        $css .= $this->getCssFontStyles($this->getParam("titleFontStyle"));
        $css .= $this->getCssPaddingMargin("title", "padding");
        $css .= $this->getCssPaddingMargin("title", "margin");
        $css .= "}\n";

        return ($css);
    }

    /**
     *
     * get caption field override css
     * @param $field
     * @return string
     */
    private function getFieldDescriptionOverrideCss($field) {

        $cssFormID = "#" . $this->formID_html;

        $css = "";

        $id = UniteFunctionsForms::getVal($field, "id");

        $css .= "{$cssFormID} #uf_field_wrapper_{$id} .uf-field-label" . "{";

        $descriptionTextShadowColor = $this->getParam("descriptionTextShadowColor");
        $descriptionTextShadowH = $this->getParam("descriptionTextShadowH");
        $descriptionTextShadowV = $this->getParam("descriptionTextShadowV");
        $descriptionTextShadowBlur = $this->getParam("descriptionTextShadowBlur");
        $css .= "text-shadow: {$descriptionTextShadowH}px {$descriptionTextShadowV}px {$descriptionTextShadowBlur}px {$descriptionTextShadowColor} !important;";

        $descriptionBoxShadowColor = $this->getParam("descriptionBoxShadowColor");
        $descriptionBoxShadowH = $this->getParam("descriptionBoxShadowH");
        $descriptionBoxShadowV = $this->getParam("descriptionBoxShadowV");
        $descriptionBoxShadowBlur = $this->getParam("descriptionBoxShadowBlur");
        $isInset = $this->getParam("descriptionBoxShadowInset", false, self::MODE_FORCE_BOOLEAN);
        $strInset = ($isInset ? "inset" : "");
        $css .= "box-shadow: {$strInset} {$descriptionBoxShadowH}px {$descriptionBoxShadowV}px {$descriptionBoxShadowBlur}px {$descriptionBoxShadowColor} !important;";

        //set background
        $cssBG = $this->getCssBackground("description");
        $css .= $cssBG;

        //set border
        $cssBorder = $this->getCssBorder("description");
        $css .= $cssBorder;

        $width = $this->getParam("descriptionWidth");
        if (!empty($width))
            $css .= "width: {$width} !important;";

        $cssFont = $this->getCssFont("description");
        if (!empty($cssFont))
            $css .= $cssFont;

        $align = $this->getParam("descriptionAlign");
        if (!empty($align))
            $css .= " text-align:{$align}!important;";
        $css .= $this->getCssFontStyles($this->getParam("descriptionFontStyle"));
        $css .= $this->getCssPaddingMargin("description", "padding");
        $css .= $this->getCssPaddingMargin("description", "margin");
        $css .= "}\n";

        return ($css);
    }

    
    /**
     *
     * get captcha field override css
     */
    private function getFieldCaptchaOverrideCss($field) {

        $cssFormID = "#" . $this->formID_html;

        $css = "";

        $id = UniteFunctionsForms::getVal($field, "id");
        $width = UniteFunctionsForms::getVal($field, "width");        //TODO: remove me
        $align = UniteFunctionsForms::getVal($field, "align");

        $css .= "{$cssFormID} #{$id}_outer {";
        switch($align){
            case "center": $css .= "margin: 0 auto !important;"; break;
            case "left": $css .= "margin: 0 auto 0 0 !important;"; break;
            case "right": $css .= "margin: 0 0 0 auto !important;"; break;
        }
        $css .= "} ";
        $css .= "{$cssFormID} #{$id} .uf-field-label {";
        $marginTop = UniteFunctionsForms::getVal($field, "labelMargin");
        $css .= "margin-top: {$marginTop}px";
        $css .= "}";

        //put captcha wrapper css
        $css .= "{$cssFormID} #{$id} {";

        $arrBorder = array(
            "style" => UniteFunctionsForms::getVal($field, "borderType"),
            "width" => UniteFunctionsForms::getVal($field, "borderWidth"),
            "color" => UniteFunctionsForms::getVal($field, "borderColor"),
            "radius" => UniteFunctionsForms::getVal($field, "borderRadius")
        );

        $css .= $this->getCssBorder("override", $arrBorder);
        $css .= "box-sizing: content-box !important; display: inline-block !important;";
        $css .= "}";

        return ($css);
    }

    private function getFieldRadioOverrideCss($field) {
        $cssFormID = "#" . $this->formID_html;
        $id = UniteFunctionsForms::getVal($field, "id");
        $labelFieldColor = UniteFunctionsForms::getVal($field, "labelFieldColor");
        $labelFontSize = UniteFunctionsForms::getVal($field, "labelFontSize");
        $fieldTextColor = UniteFunctionsForms::getVal($field, "fieldTextColor");
        $fieldFontSize = UniteFunctionsForms::getVal($field, "fieldFontSize");

        $css = "{$cssFormID} input[name=\"{$id}\"] ~ span {";
        $css .= "color:{$fieldTextColor} !important;font-size: {$fieldFontSize}px !important;";
        $css .= "}";
        //
        $css .= "{$cssFormID} #uf_field_wrapper_{$id} > .uf-field-label {";
        $css .= "color:{$labelFieldColor} !important;font-size: {$labelFontSize}px !important;";
        $css .= "}";

        return ($css);
    }

    private function getFieldImageOverrideCss($field){
        $id = UniteFunctionsForms::getVal($field, "id");
        $marginTop = UniteFunctionsForms::getVal($field, "marginTop", "0") . "px";
        $marginBottom = UniteFunctionsForms::getVal($field, "marginBottom", "0") . "px";

        if ($this->params['formDirection'] === "rtl") {
            $marginRight = UniteFunctionsForms::getVal($field, "marginSide", "0") . "px";
            $marginLeft = 0;
        } else {
            $marginRight = 0;
            $marginLeft = UniteFunctionsForms::getVal($field, "marginSide", "0") . "px";
        }
        $float = "none";
        $display = "inline";
        switch(UniteFunctionsForms::getVal($field, "align", "none")){
            case "center":
                $marginLeft = "auto";
                $marginRight = "auto";
                $display = "block";
                break;
            case "left":
                $float = "left";
                break;
            case "right":
                $float ="right";
                break;
        }
        $css = "#{$id} > img {";
        $css .= "margin: {$marginTop} {$marginRight} {$marginBottom} {$marginLeft} !important;";
        $css .= "float: {$float} !important;";
        $css .= "display: {$display} !important;";
        $css .= "}";

        return ($css);
    }

    /**
     *
     * get fields override css
     */
    private function getOverrideCss() {
        $css = "";

        foreach ($this->data as $field) {

            $fieldType = UniteFunctionsForms::getVal($field, "type");
            $this->validateType($fieldType);

            $isOverride = UniteFunctionsForms::getVal($field, "isPrivate");
            $isOverride = UniteFunctionsForms::strToBool($isOverride);
            if (in_array($fieldType, array(self::FORM_TYPE_CAPTCHA, self::FORM_TYPE_PARAGRAPH, self::FORM_TYPE_TITLE, self::FORM_TYPE_IMAGE)))
                $isOverride = true;

            if ($isOverride == false)
                continue;

            switch ($fieldType) {
                case self::FORM_TYPE_PARAGRAPH:
                    $cssFieldTitle = $this->getFieldDescriptionOverrideCss($field);
                    $css .= $cssFieldTitle . " \n";
                    break;
                case self::FORM_TYPE_TITLE:
                    $cssFieldTitle = $this->getFieldTitleOverrideCss($field);
                    $css .= $cssFieldTitle . " \n";
                    break;
                case self::FORM_TYPE_CAPTCHA:
                    $cssFieldCaptcha = $this->getFieldCaptchaOverrideCss($field);
                    $css .= $cssFieldCaptcha . " \n";
                    break;
                case self::FORM_TYPE_RADIO:
                case self::FORM_TYPE_CHECKBOX:
                    $cssFieldRadio = $this->getFieldRadioOverrideCss($field);
                    $css .= $cssFieldRadio . " \n";
                    break;
                case self::FORM_TYPE_IMAGE:
                    $cssFieldImage = $this->getFieldImageOverrideCss($field);
                    $css .= $cssFieldImage . " \n";
                    break;
                default:
                    $cssField = $this->getFieldOverrideCss($field);
                    $cssFieldCaption = $this->getFieldCaptionOverrideCss($field);
                    $css .= $cssField . " \n";
                    if (!empty($cssFieldCaption))
                        $css .= $cssFieldCaption . " \n";
                break;
            }

        }

        return ($css);
    }


    /**
     *
     * put radio field
     */
    private function putFieldRadioCheckbox($field, $type = self::FORM_TYPE_RADIO) {

        $id = UniteFunctionsForms::getVal($field, "id");
        $options = UniteFunctionsForms::getVal($field, "options");
        $addition = $this->getHtmlRequired($field);

        $wrapperClass = "ko-lst uf-field uf-field-radio";
        if ($type == self::FORM_TYPE_CHECKBOX)
            $wrapperClass = "ko-lst uf-field uf-field-checkbox";

        ?>
        <ul id="<?php echo $id ?>" class="<?php echo $wrapperClass ?>" <?php echo $addition ?>>
            <?php

            foreach ($options as $index => $option) {

                $inputID = $id . "_item{$index}";
                $value = $option['value'];
                $label = $option['label'];

                $isSelected = false;

                if (isset($option['checked'])) {
                    $isSelected = $option['checked'];
                    $isSelected = UniteFunctionsForms::strToBool($isSelected);
                }

                //set selected
                $addition = "";
                if ($isSelected == true)
                    $addition = " checked='checked'";

                $divClass = "uf-radio-item-wrapper";
                $itemClass = "uf-radio-item";
                $labelClass = "uf-fielditem-label uf-radio-label";
                $inputType = "radio";

                if ($type == self::FORM_TYPE_CHECKBOX) {
                    $divClass = "uf-checkbox-item-wrapper";
                    $itemClass = "uf-checkbox-item";
                    $labelClass = "uf-fielditem-label uf-checkbox-label";
                    $inputType = "checkbox";
                }

                ?>
                <li>
                    <label class='<?php echo $divClass ?>'>
                        <input id="<?php echo $inputID ?>" type="<?php echo $inputType ?>" name="<?php echo $id ?>"
                               value="<?php echo $value ?>" <?php echo $addition ?>
                               class='<?php echo $itemClass ?>'><span
                            class='<?php echo $labelClass ?>'><?php echo $label ?></span>
                    </label>
                </li>
                <?php
            }
            ?>
        </ul>
        <?php
    }


    /**
     *
     * put select field
     */
    private function putFieldSelect($field) {
        $id = UniteFunctionsForms::getVal($field, "id");
        $options = UniteFunctionsForms::getVal($field, "options");
        $addition = $this->getHtmlRequired($field);

        ?>
        <select id="<?php echo $id ?>" name="<?php echo $id ?>"
                class="uf-field uf-input-field uf-field-select" <?php echo $addition ?>>
            <?php
            foreach ($options as $option) {
                $value = $option['value'];
                $label = $option['label'];
                $selected = "";
                $isSelected = false;
                if (isset($option['checked'])) {
                    $isSelected = $option['checked'];
                    $isSelected = UniteFunctionsForms::strToBool($isSelected);
                }
                if ($isSelected) {
                    $selected = "selected=\"selected\"";
                }
                ?>
                <option <?php echo $selected ?> value="<?php echo $value ?>"><?php echo $label ?></option>
                <?php
            }
            ?>
        </select>
        <?php
    }


    /**
     *
     * put text field
     */
    private function putFieldText($field) {
        $id = UniteFunctionsForms::getVal($field, "id");
        $value = UniteFunctionsForms::getVal($field, "value");
        $addition = $this->getHtmlRequired($field);
        $hasPlaceholder = UniteFunctionsForms::getVal($field, "has-placeholder", false);
        $hasPlaceholderClass = $hasPlaceholder ? "uf-input-has-placeholder" : "";
        ?>
        <input id="<?php echo $id ?>" type="text" name="<?php echo $id ?>" value="<?php echo $value ?>"
               class='uf-field uf-input-field uf-field-text <?php echo $hasPlaceholderClass ?>' <?php echo $addition ?>>
        <?php
    }

    private function putFieldTextWithPlaceholder($field, $label) {
        $field['has-placeholder'] = true;
        ?>
        <label class="textbox-wrap">
            <?php $this->putFieldText($field); ?>
            <div class="uf-input-placeholder uf-field-label"><?php echo $label ?></div>
        </label>
        <?php
    }

    /**
     *
     * put textare field
     */
    private function putFieldTextArea($field) {
        $id = UniteFunctionsForms::getVal($field, "id");
        $value = UniteFunctionsForms::getVal($field, "value");
        $addition = $this->getHtmlRequired($field);
        $hasPlaceholder = UniteFunctionsForms::getVal($field, "has-placeholder", false);
        $hasPlaceholderClass = $hasPlaceholder ? "uf-input-has-placeholder" : "";
        ?>
        <textarea id="<?php echo $id ?>" type="text" name="<?php echo $id ?>"
                  class='uf-field uf-input-field uf-field-textarea <?php echo $hasPlaceholderClass ?>' <?php echo $addition ?>><?php echo $value ?></textarea>
        <?php
    }

    private function putFieldTextAreaWithPlaceholder($field, $label) {
        $field['has-placeholder'] = true;
        ?>
        <label class="textbox-wrap">
            <?php $this->putFieldTextArea($field); ?>
            <div class="uf-input-placeholder uf-field-label"><?php echo $label ?></div>
        </label>
        <?php
    }

    /**
     *
     * put captcha field
     */
    private function putFieldCaptcha($field) {
        $id = UniteFunctionsForms::getVal($field, "id");
        $label = UniteFunctionsForms::getVal($field, "label");
        $placeholder = UniteFunctionsForms::getVal($field, "placeholder");
        $name = "captcha";

        $width = UniteFunctionsForms::getVal($field, "width");
        $height = UniteFunctionsForms::getVal($field, "height");

        UniteFunctionsForms::validateNotEmpty($width, "captcha width");
        UniteFunctionsForms::validateNotEmpty($height, "captcha height");

        $operations = new UniteFormsOperations();

        $styleImage = "style=\"width:{$width}px;height:{$height}px;\"";
        $urlCatpchaImage = $operations->getUrlCaptcha($width, $height);

        ?>
        <div id="<?php echo $id ?>_outer" class="uf-captcha">
            <div id="<?php echo $id ?>" class="uf-captcha-wrapper-inner">
                <img alt="captcha" width="<?php echo $width ?>" height="<?php echo $height ?>"
                     src="<?php echo $urlCatpchaImage ?>" <?php echo $styleImage ?>>
                <div class="uf-captcha-input-wrapper">
                    <div class="ko-lbl uf-field-label"><?php echo $label;?></div>
                    <input class="uf-field" type="text" placeholder="<?php echo $placeholder;?>" name="<?php echo $name ?>" value="" />
                </div>
            </div>
            <div class="uf-clear"></div>
        </div>
        <?php
    }


    /**
     * put image field
     */
    private function putFieldImage($field){
        $id = UniteFunctionsForms::getVal($field, "id");
        $width = UniteFunctionsForms::getVal($field, "width", "100%");
        $height = UniteFunctionsForms::getVal($field, "height", "100%");
        $imageSrc = UniteFunctionsForms::getVal($field, "imgSrc");
        $styleImage = "style=\"width:{$width} !important; height:{$height} !important;\"";
        ?>
            <div id="<?php echo $id ?>" class="uf-image-wrapper">
                <img alt="image" src="<?php echo GlobalsUniteForms::$urlRoot . $imageSrc ?>" <?php echo $styleImage ?>>
            </div>
            <div class="uf-clear"></div>
        <?php
    }
	
    
    /**
     * put file field
     */
    private function putFieldFile($field){
        $id = UniteFunctionsForms::getVal($field, "id");
        ?>
        <div id="<?php echo $id ?>">
            <input type="file" class="uf-file" name="<?php echo $id?>"/>
        </div>
        <div class="uf-clear"></div>
        <?php
    }
    
    
    /**
     * get required html addition from field
     */
    private function getHtmlRequired($field) {

        $isRequired = UniteFunctionsForms::getVal($field, "required");
        $isRequired = UniteFunctionsForms::strToBool($isRequired);

        $addition = "";
        if ($isRequired == true)
            $addition = 'data-required="true"';

        return ($addition);
    }

    /**
     *
     * put form fields
     */
    private function putFields() {

        if (empty($this->data))
            return (false);

        $labelPositionClass = "label-location-" . $this->params['labelAlign'];
        $numItems = count($this->data);
        foreach ($this->data as $index => $field):
            $type = UniteFunctionsForms::getVal($field, "type");
            $id = UniteFunctionsForms::getVal($field, "id");
            $label = UniteFunctionsForms::getVal($field, "label");
            $isRequired = UniteFunctionsForms::getVal($field, "required");
            $isRequired = UniteFunctionsForms::strToBool($isRequired);

            if($type === self::FORM_TYPE_BUTTON) continue;

            $addition = "";
            if ($isRequired == true) {
                $label .= " *";
            }

            $wrapperID = "uf_field_wrapper_" . $id;

            if ($type == self::FORM_TYPE_CAPTCHA)
                $wrapperID = "uf_field_wrapper_capcha" . $this->formID;

            //get sap class
            $isLast = $index == ($numItems - 1);

            $sapClass = "uf-clear";
            if ($isLast == false)
                $sapClass .= " uf-sap";

            ?>
            <div id="<?php echo $wrapperID ?>" class="uf-field-wrapper <?php echo $labelPositionClass;?>">
                <?php
                switch ($type) {
                    case self::FORM_TYPE_CAPTCHA:
                    case self::FORM_TYPE_BUTTON:
                    case self::FORM_TYPE_IMAGE:
                        break;
                    case self::FORM_TYPE_TEXT:
                    case self::FORM_TYPE_AREA:
                        if ($this->getParam("labelAlign", "top") === "in")
                            break;
                    default:
                        ?>
                        <div class='uf-field-label'><?php echo nl2br($label) ?></div>
                        <?php
                        break;
                }
                ?>

                <?php
                switch ($type) {
                    case self::FORM_TYPE_RADIO:
                        $this->putFieldRadioCheckbox($field, self::FORM_TYPE_RADIO);
                        break;
                    case self::FORM_TYPE_CHECKBOX:
                        $this->putFieldRadioCheckbox($field, self::FORM_TYPE_CHECKBOX);
                        break;
                    case self::FORM_TYPE_SELECT:
                        $this->putFieldSelect($field);
                        break;
                    case self::FORM_TYPE_TEXT:
                        if ($this->getParam("labelAlign", "top") === "in") {
                            $this->putFieldTextWithPlaceholder($field, $label);
                        } else {
                            $this->putFieldText($field);
                        }

                        break;
                    case self::FORM_TYPE_AREA:
                        if ($this->getParam("labelAlign", "top") === "in") {
                            $this->putFieldTextAreaWithPlaceholder($field, $label);
                        } else {
                            $this->putFieldTextArea($field);
                        }
                        break;                            //skip form field for title or paragraph
                    case self::FORM_TYPE_TITLE:
                    case self::FORM_TYPE_PARAGRAPH:
                        break;
                    case self::FORM_TYPE_CAPTCHA:
                        $this->putFieldCaptcha($field);
                        break;
                    case self::FORM_TYPE_IMAGE:
                        $this->putFieldImage($field);
                        break;
                    case self::FORM_TYPE_FILE:
                        $this->putFieldFile($field);
                        break;
                    case self::FORM_TYPE_BUTTON:
                        continue;
                        break;
                    default:
                        echo $type;
                        break;
                }

                ?>
            </div>
            <div class="<?php echo $sapClass ?>"></div>
            <?php
        endforeach;    //foreach

    }


    /**
     *
     * put send button
     */
    private function putSendButton() {
        $sendButton = null;
        foreach ($this->data as $element) {
            if ($element['type'] === self::FORM_TYPE_BUTTON) {
                $sendButton = $element;
            }
        }

        $text = UniteFunctionsForms::getVal($sendButton, "value");
        $mess = (array)$this->getParam('loadmess');

        if (array_key_exists('label', $mess)) {
            $loadLabel = $mess['label'];
        } else {
            $loadLabel = 'Loading...';
        }

        $mess = (array)$this->getParam('errmess');
        if (array_key_exists('label', $mess)) {
            $errLabel = $mess['label'];
        } else {
            $errLabel = 'An error has occurred.';
        }


        ?>
        <div class="uf-sap"></div>
        <div class="uf-sendbutton-wrapper">
            <input type="button" class="uf-sendbutton" href="javascript:void(0)" value="<?php echo $text ?>">
            <div class="uf-clear"></div>
            <div class="uf-sending-message hidden"><?php echo $loadLabel; ?></div>
            <div class="uf-error-message hidden"><?php echo $errLabel; ?></div>
        </div>
        <div class="uf-clear"></div>
        <?php
    }


    /**
     *
     * put css
     */
    private function putCss() {

        $cssFormID = "#" . $this->formID_html;

        //get general form css
        $cssGeneral = $this->getCssGeneral();
        $cssBorder = $this->getCssBorder();
        $cssMargin = "margin:0px auto;";        //todo: make the position settings
        $cssBackground = $this->getCssBackground();

        $cssForm = $cssGeneral . $cssBorder . $cssMargin . $cssBackground;
        $cssSap = $this->getCssSap();
        $cssFields = $this->getCssFields();
        $cssLabels = $this->getCssLabel();
        $cssTextAreaLabels = $this->getCssTextAreaLabel();
        $cssSendButton = $this->getCssSendButton();
        $cssTextbox = $this->getCssTextbox();
        $cssTextArea = $this->getCssTextArea();
        $cssCheckboxRadioLabels = $this->getCssRadioCheckboxLabel();
        $overrideCss = $this->getOverrideCss();
        $cssErrMess = $this->getCssMessages("errmess");
        $cssLoadMess = $this->getCssMessages("loadmess");
        $cssConfirmMess = $this->getCssMessages("succmess");
        
        
        $css = "\n<style type='text/css'>\n";
        $css .= "{$cssFormID}_form { $cssForm } \n";
        $css .= "{$cssFormID} .uf-input-field{ $cssFields } \n";
        $css .= "{$cssFormID} .uf-captcha-wrapper-inner .uf-field{ $cssFields } \n";
        $css .= "{$cssFormID} .uf-field-label{ $cssLabels } \n";
        if (strlen($cssTextAreaLabels) > 0)
            $css .= "{$cssFormID} .uf-field-textarea.uf-input-has-placeholder ~ .uf-field-label{ $cssTextAreaLabels } \n";
        $css .= "{$cssFormID} .uf-fielditem-label { $cssCheckboxRadioLabels } \n";
        $css .= "{$cssFormID} .uf-sap{ $cssSap } \n";
        $css .= "{$cssFormID} .uf-sendbutton{ $cssSendButton } \n";
        $css .= "{$cssFormID} .uf-field-text{ $cssTextbox } \n";
        $css .= "{$cssFormID} .uf-field-textarea{ $cssTextArea } \n";
        $css .= "{$cssFormID} .uf-sending-message{ $cssLoadMess } \n";
        $css .= "{$cssFormID} .uf-error-message{ $cssErrMess } \n";
        $css .= "{$cssFormID} .uf-confirm-message{ $cssConfirmMess } \n";
		
        $css .= $overrideCss;
        $css .= "</style>\n";

        echo $css;
    }


    /**
     *
     * put javascript
     */
    private function putJs() {

        ?>
        <script type="text/javascript">

            jQuery(document).ready(function () {
                var uniteForms = new UniteForms();
                uniteForms.init("<?php echo $this->formID_form?>", "<?php echo $this->formID?>", {
                    "url_ajax": "<?php echo GlobalsUniteForms::$urlAjax?>"
                });
            });

        </script>
        <?php
    }


    /**
     *
     * put form base
     */
    private function putBase() {

        $formID_form = $this->formID_html . "_form";
        $mess = (array)$this->getParam('succmess');
        $formDirection = $this->params['formDirection'];
        if (array_key_exists('label', $mess)) {
            $succLabel = $mess['label'];
        } else {
            $succLabel = 'Form sent!';
        }

        ?>

        <!-- START UNITE FORMS <?php echo UF_VERSION ?>-->

        <?php

        $this->putCss();

        ?>

        <div id="<?php echo $this->formID_html ?>" class="uf-main">
            <form id="<?php echo $formID_form ?>" class="uf-form" dir="<?php echo $formDirection ?>">
                <div class="uf-formcontent">
                    <?php $this->putFields() ?>
                    <?php $this->putSendButton() ?>
                </div>
                <div class="uf-confirm-message" style="display:none;">
                    <?php echo $succLabel; ?>
                </div>
            </form>
        </div>

        <?php
        $this->putJs();
        ?>
        <!-- END UNITE FORMS -->
        <?php
    }

}

?>