<?php

/**
 * @package Unite Forms for Joomla 1.7-3.5
 * @author UniteCMS.net
 * @copyright (C) 2014 Unite CMS, All Rights Reserved.
 * @license GNU/GPLv3 http://www.gnu.org/licenses/gpl-3.0.html
 * */

defined('_JEXEC') or die;

?>

<uib-accordion-group is-open="fs.isOpen.description" id="section-description">
    <uib-accordion-heading>
        <i class="accordion-icon fa" ng-class="{'fa-caret-down': fs.isOpen.description, 'fa-caret-right': !fs.isOpen.description}"></i>
        Description Settings
    </uib-accordion-heading>
    <fieldset>
        <div class="row">
            <div class="form-group col-lg-3 col-md-6 col-sm-6">
                <?php $this->o->drawSettingTitle("descriptionColor") ?>
                <?php $this->o->drawSetting("descriptionColor", "fs.activeFormStyles.descriptionColor") ?>
            </div>
            <div class="form-group col-lg-3 col-md-6 col-sm-6">
                <?php $this->o->drawSettingTitle("descriptionFontSize") ?>
                <?php $this->o->drawSetting("descriptionFontSize", "fs.activeFormStyles.descriptionFontSize") ?>
            </div>
            <div class="form-group col-lg-3 col-md-6 col-sm-6">
                <?php $this->o->drawSettingTitle("descriptionFontStyle") ?>
                <?php $this->o->drawSetting("descriptionFontStyle", "fs.activeFormStyles.descriptionFontStyle") ?>
            </div>
        </div>
    </fieldset>

    <fieldset>
        <div class="row">
            <div class="form-group col-lg-3 col-md-6 col-sm-6">
                <?php $this->o->drawSettingTitle("descriptionTextShadowColor") ?>
                <?php $this->o->drawSetting("descriptionTextShadowColor", "fs.activeFormStyles.descriptionTextShadowColor") ?>
            </div>
            <div class="form-group col-lg-3 col-md-6 col-sm-6">
                <?php $this->o->drawSettingTitle("descriptionTextShadowH") ?>
                <?php $this->o->drawSetting("descriptionTextShadowH", "fs.activeFormStyles.descriptionTextShadowH") ?>
            </div>
            <div class="form-group col-lg-3 col-md-6 col-sm-6">
                <?php $this->o->drawSettingTitle("descriptionTextShadowV") ?>
                <?php $this->o->drawSetting("descriptionTextShadowV", "fs.activeFormStyles.descriptionTextShadowV") ?>
            </div>
            <div class="form-group col-lg-3 col-md-6 col-sm-6">
                <?php $this->o->drawSettingTitle("descriptionTextShadowBlur") ?>
                <?php $this->o->drawSetting("descriptionTextShadowBlur", "fs.activeFormStyles.descriptionTextShadowBlur") ?>
            </div>
        </div>
    </fieldset>

    <fieldset>
        <div class="row">
            <div class="form-group col-lg-6 col-md-12 col-sm-12">
                <?php $this->o->drawSettingTitle("descriptionBackgroundType") ?>
                <?php $this->o->drawSetting("descriptionBackgroundType", "fs.activeFormStyles.descriptionBackgroundType") ?>
            </div>
            <div class="form-group col-lg-3 col-md-6 col-sm-6"
                 ng-if="fs.activeFormStyles.descriptionBackgroundType == 'solid' || fs.activeFormStyles.descriptionBackgroundType == 'img'">
                <?php $this->o->drawSettingTitle("descriptionBackgroundColor") ?>
                <?php $this->o->drawSetting("descriptionBackgroundColor", "fs.activeFormStyles.descriptionBackgroundColor") ?>
            </div>
            <div ng-if="fs.activeFormStyles.descriptionBackgroundType == 'gradient'">
                <div class="form-group col-lg-3 col-md-6 col-sm-6">
                    <?php $this->o->drawSettingTitle("descriptionBackgroundStartColor") ?>
                    <?php $this->o->drawSetting("descriptionBackgroundStartColor", "fs.activeFormStyles.descriptionBackgroundStartColor") ?>
                </div>
                <div class="form-group col-lg-3 col-md-6 col-sm-6">
                    <?php $this->o->drawSettingTitle("descriptionBackgroundEndColor") ?>
                    <?php $this->o->drawSetting("descriptionBackgroundEndColor", "fs.activeFormStyles.descriptionBackgroundEndColor") ?>
                </div>
            </div>
            <div class="form-group form_img" ng-if="fs.activeFormStyles.descriptionBackgroundType == 'img'">
                <div class="row">
                    <div class="form-group col-sm-12">
                        <?php $this->o->drawSettingTitle("descriptionBackgroundImg") ?>
                        <?php $this->o->drawSetting("descriptionBackgroundImg", "fs.activeFormStyles.descriptionBackgroundImg") ?>
                    </div>
                </div>
                <div class="row">
                    <div class="form-group col-lg-4 col-md-6 col-sm-6">
                        <?php $this->o->drawSettingTitle("descriptionBackgroundFit") ?>
                        <?php $this->o->drawSetting("descriptionBackgroundFit", "fs.activeFormStyles.descriptionBackgroundFit") ?>
                    </div>
                    <div class="form-group col-lg-4 col-md-6 col-sm-6 text-nowrap">
                        <?php $this->o->drawSettingTitle("descriptionBackgroundRepeat") ?>
                        <?php $this->o->drawSetting("descriptionBackgroundRepeat", "fs.activeFormStyles.descriptionBackgroundRepeat") ?>
                    </div>
                    <div class="form-group col-lg-4 col-md-6 col-sm-6 text-nowrap">
                        <?php $this->o->drawSettingTitle("descriptionBackgroundPosition") ?>
                        <?php $this->o->drawSetting("descriptionBackgroundPosition", "fs.activeFormStyles.descriptionBackgroundPosition") ?>
                    </div>
                </div>
            </div>
        </div>
    </fieldset>

    <fieldset>
        <div class="row">
            <div class="form-group col-lg-3 col-md-6 col-sm-6">
                <?php $this->o->drawSettingTitle("descriptionBorderType") ?>
                <?php $this->o->drawSetting("descriptionBorderType", "fs.activeFormStyles.descriptionBorderType") ?>
            </div>
            <div ng-if="fs.activeFormStyles.descriptionBorderType !== 'none'">
                <div class="form-group col-lg-3 col-md-6 col-sm-6">
                    <?php $this->o->drawSettingTitle("descriptionBorderSize") ?>
                    <?php $this->o->drawSetting("descriptionBorderSize", "fs.activeFormStyles.descriptionBorderSize") ?>
                </div>
                <div class="form-group col-lg-3 col-md-6 col-sm-6">
                    <?php $this->o->drawSettingTitle("descriptionBorderColor") ?>
                    <?php $this->o->drawSetting("descriptionBorderColor", "fs.activeFormStyles.descriptionBorderColor") ?>
                </div>
                <div class="form-group col-lg-3 col-md-6 col-sm-6">
                    <?php $this->o->drawSettingTitle("descriptionBorderRadius") ?>
                    <?php $this->o->drawSetting("descriptionBorderRadius", "fs.activeFormStyles.descriptionBorderRadius") ?>
                </div>
            </div>
        </div>
    </fieldset>

    <fieldset>
        <div class="row">
            <div class="form-group col-lg-3 col-md-6 col-sm-6">
                <?php $this->o->drawSettingTitle("descriptionBoxShadowColor") ?>
                <?php $this->o->drawSetting("descriptionBoxShadowColor", "fs.activeFormStyles.descriptionBoxShadowColor") ?>
            </div>
            <div class="form-group col-lg-3 col-md-6 col-sm-6">
                <?php $this->o->drawSettingTitle("descriptionBoxShadowH") ?>
                <?php $this->o->drawSetting("descriptionBoxShadowH", "fs.activeFormStyles.descriptionBoxShadowH") ?>
            </div>
            <div class="form-group col-lg-3 col-md-6 col-sm-6">
                <?php $this->o->drawSettingTitle("descriptionBoxShadowV") ?>
                <?php $this->o->drawSetting("descriptionBoxShadowV", "fs.activeFormStyles.descriptionBoxShadowV") ?>
            </div>
            <div class="form-group col-lg-3 col-md-6 col-sm-6">
                <?php $this->o->drawSettingTitle("descriptionBoxShadowBlur") ?>
                <?php $this->o->drawSetting("descriptionBoxShadowBlur", "fs.activeFormStyles.descriptionBoxShadowBlur") ?>
            </div>
            <div class="form-group col-lg-3 col-md-6 col-sm-6 uf-inline-checkbox">
                <label>
                    <?php $this->o->drawSetting("descriptionBoxShadowInset", "fs.activeFormStyles.descriptionBoxShadowInset") ?>
                    Inset
                </label>
            </div>
        </div>
    </fieldset>

    <fieldset>
        <div class="row">
            <div class="form-group col-lg-6 col-md-8 col-sm-12">
                <?php $this->o->drawSettingTitle("descriptionWidth") ?>
                <?php $this->o->drawSetting("descriptionWidth", "fs.activeFormStyles.descriptionWidth") ?>
            </div>
        </div>

    </fieldset>

    <fieldset class="with-legend-line">
        <legend>
            Padding
        </legend>
        <label class="uf-checkbox-lock pull-right">
            <input type="checkbox" ng-model="fs.lockersState.descriptionPadding" ng-click="fs.lockChanges('descriptionPadding')"/>
            <i class="fa fa-lock"></i>
        </label>
        <div class="row">
            <div class="form-group col-lg-3 col-md-6 col-sm-6">
                <?php $this->o->drawSettingTitle("descriptionPaddingTop") ?>
                <?php $this->o->drawSetting("descriptionPaddingTop", "fs.activeFormStyles.descriptionPaddingTop") ?>
            </div>
            <div class="form-group col-lg-3 col-md-6 col-sm-6">
                <?php $this->o->drawSettingTitle("descriptionPaddingRight") ?>
                <?php $this->o->drawSetting("descriptionPaddingRight", "fs.activeFormStyles.descriptionPaddingRight") ?>
            </div>
            <div class="form-group col-lg-3 col-md-6 col-sm-6">
                <?php $this->o->drawSettingTitle("descriptionPaddingBottom") ?>
                <?php $this->o->drawSetting("descriptionPaddingBottom", "fs.activeFormStyles.descriptionPaddingBottom") ?>
            </div>
            <div class="form-group col-lg-3 col-md-6 col-sm-6">
                <?php $this->o->drawSettingTitle("descriptionPaddingLeft") ?>
                <?php $this->o->drawSetting("descriptionPaddingLeft", "fs.activeFormStyles.descriptionPaddingLeft") ?>
            </div>
        </div>
    </fieldset>

    <fieldset class="with-legend-line">
        <legend>
            Margin
        </legend>
        <label class="uf-checkbox-lock pull-right">
            <input type="checkbox" ng-model="fs.lockersState.descriptionMargin" ng-click="fs.lockChanges('descriptionMargin')"/>
            <i class="fa fa-lock"></i>
        </label>
        <div class="row">
            <div class="form-group col-lg-3 col-md-6 col-sm-6">
                <?php $this->o->drawSettingTitle("descriptionMarginTop") ?>
                <?php $this->o->drawSetting("descriptionMarginTop", "fs.activeFormStyles.descriptionMarginTop") ?>
            </div>
            <div class="form-group col-lg-3 col-md-6 col-sm-6">
                <?php $this->o->drawSettingTitle("descriptionMarginRight") ?>
                <?php $this->o->drawSetting("descriptionMarginRight", "fs.activeFormStyles.descriptionMarginRight") ?>
            </div>
            <div class="form-group col-lg-3 col-md-6 col-sm-6">
                <?php $this->o->drawSettingTitle("descriptionMarginBottom") ?>
                <?php $this->o->drawSetting("descriptionMarginBottom", "fs.activeFormStyles.descriptionMarginBottom") ?>
            </div>
            <div class="form-group col-lg-3 col-md-6 col-sm-6">
                <?php $this->o->drawSettingTitle("descriptionMarginLeft") ?>
                <?php $this->o->drawSetting("descriptionMarginLeft", "fs.activeFormStyles.descriptionMarginLeft") ?>
            </div>
        </div>
    </fieldset>

    <fieldset>
        <div class="row">
            <div class="form-group col-lg-6 col-md-8 col-sm-12">
                <?php $this->o->drawSettingTitle("descriptionAlign") ?>
                <?php $this->o->drawSetting("descriptionAlign", "fs.activeFormStyles.descriptionAlign") ?>
            </div>
        </div>
    </fieldset>
</uib-accordion-group>