<?php

/**
 * @package Unite Forms for Joomla 1.7-3.5
 * @author UniteCMS.net
 * @copyright (C) 2014 Unite CMS, All Rights Reserved.
 * @license GNU/GPLv3 http://www.gnu.org/licenses/gpl-3.0.html
 * */

defined('_JEXEC') or die;

?>

<uib-accordion-group is-open="fs.isOpen.messages" id="section-messages">
    <uib-accordion-heading>
        <i class="accordion-icon fa"
           ng-class="{'fa-caret-down': fs.isOpen.messages, 'fa-caret-right': !fs.isOpen.messages}"></i>
        Design Success, Error & Loading
    </uib-accordion-heading>
    <fieldset>
        <div class="row">
            <div class="col-sm-12">
                <label class="select-customisized">
                    <select class="form-control" ng-model="fs.formState" ng-change="fs.showFormMessage()">
                        <option value="normal">Normal Form Status</option>
                        <option value="loadmess">Sending Form Message</option>
                        <option value="errmess">Error Message</option>
                        <option value="succmess">Success Message</option>
                    </select>
                </label>
            </div>
        </div>
    </fieldset>
    <div ng-show="fs.formState !== 'normal'">
        <fieldset>
            <div class="row">
                <div class="form-group col-lg-3 col-md-6 col-sm-6">
                    <label>
                        Color:
                    </label>
                    <input type="text" ng-farbtastic
                           class="form-control"
                           ng-model="fs.activeFormMessage.color"/>
                </div>
                <div class="form-group col-lg-3 col-md-6 col-sm-6">
                    <label>
                        Font Size:
                    </label>

                    <div class="input-group">
                        <input type="text" class='regular-text form-control'
                               data-ng-model="fs.activeFormMessage.fontSize" data-uf-input-spinner/>

                        <span class="input-group-addon">PX</span>
                    </div>
                </div>
            </div>
        </fieldset>

        <fieldset>
            <div class="row">
                <div class="form-group col-lg-3 col-md-6 col-sm-6">
                    <label>
                        Text Shadow:
                    </label>
                    <input type="text" ng-farbtastic
                           class="form-control"
                           ng-model="fs.activeFormMessage.shadowColor"/>
                </div>
                <div class="form-group col-lg-3 col-md-6 col-sm-6">
                    <label>
                        H:
                    </label>
                    <div class="input-group">
                        <input type="text" class='regular-text form-control'
                               data-ng-model="fs.activeFormMessage.shadowH" data-uf-input-spinner
                            />
                        <span class="input-group-addon">PX</span>
                    </div>
                </div>
                <div class="form-group col-lg-3 col-md-6 col-sm-6">
                    <label>
                        V:
                    </label>

                    <div class="input-group">
                        <input type="text" class='regular-text form-control'
                               data-ng-model="fs.activeFormMessage.shadowV" data-uf-input-spinner/>
                        <span class="input-group-addon">PX</span>
                    </div>
                </div>
                <div class="form-group col-lg-3 col-md-6 col-sm-6">
                    <label>
                        Blur:
                    </label>

                    <div class="input-group">
                        <input type="text" class='regular-text form-control'
                               data-ng-model="fs.activeFormMessage.shadowBlur" data-uf-input-spinner/>
                        <span class="input-group-addon">PX</span>
                    </div>
                </div>
            </div>
        </fieldset>

        <fieldset>
            <div class="row">
                <div class="form-group col-lg-6 col-md-12 col-sm-12">
                    <label>
                        Background:
                    </label>
                    <label class="select-customisized">
                        <select ng-model="fs.activeFormMessage.bgType"
                                class=" form-control">
                            <option value="none">None</option>
                            <option value="solid">Solid</option>
                            <option value="gradient">Gradient</option>
                            <option value="img">Image</option>
                        </select></label>
                </div>
                <div class="form-group col-lg-3 col-md-6 col-sm-6"
                     ng-if="fs.activeFormMessage.bgType == 'solid' || fs.activeFormMessage.bgType == 'img'">
                    <label>
                        Color:
                    </label>
                    <input type="text" ng-farbtastic
                           class="form-control"
                           ng-model="fs.activeFormMessage.bgStartColor"/>
                </div>
                <div ng-if="fs.activeFormMessage.bgType == 'gradient'">
                    <div class="form-group col-lg-3 col-md-6 col-sm-6">
                        <label>
                            Start Color:
                        </label>
                        <input type="text" ng-farbtastic
                               class="form-control"
                               ng-model="fs.activeFormMessage.bgStartColor"/>
                    </div>
                    <div class="form-group col-lg-3 col-md-6 col-sm-6">
                        <label>
                            End Color:
                        </label>
                        <input type="text" ng-farbtastic
                               class="form-control"
                               ng-model="fs.activeFormMessage.bgEndColor"/>
                    </div>
                </div>
            </div>
            <div class="form-group" ng-if="fs.activeFormMessage.bgType == 'img'">
                <div class="row">
                    <div class="form-group col-sm-12">
                        <label>
                            Background URL:
                        </label>

                        <div data-uf-image-browse="" data-ng-model="fs.activeFormMessage.bgImg"></div>
                    </div>
                </div>
                <div class="row">
                    <div class="form-group col-lg-4 col-md-6 col-sm-6">
                        <label for="fieldBgFit">
                            Background Fit:
                        </label>
                        <label class="select-customisized">
                            <select id="fieldBgFit" ng-model="fs.activeFormMessage.bgFit" class="form-control">
                                <option value="auto">Auto</option>
                                <option value="cover">Cover</option>
                                <option value="contain">Contain</option>
                            </select></label>
                    </div>
                    <div class="form-group col-lg-4 col-md-6 col-sm-6 text-nowrap">
                        <label for="fieldBgRepeat">
                            Repeat:
                        </label>
                        <label class="select-customisized">
                            <select id="fieldBgRepeat" ng-model="fs.activeFormMessage.bgRepeat" class="form-control">
                                <option value="repeat">Repeat</option>
                                <option value="no-repeat">No-Repeat</option>
                                <option value="repeat-x">Repeat X</option>
                                <option value="repeat-y">Repeat Y</option>
                            </select></label>
                    </div>
                    <div class="form-group col-lg-4 col-md-6 col-sm-6 text-nowrap">
                        <label for="fieldBgPosition">
                            Position:
                        </label>
                        <label class="select-customisized">
                            <select id="fieldBgPosition" ng-model="fs.activeFormMessage.bgPosition"
                                    class="form-control">
                                <option value="left top">Left Top</option>
                                <option value="center top">Center Top</option>
                                <option value="right top">Right Top</option>
                                <option value="left center">Left Center</option>
                                <option value="center center">Center Center</option>
                                <option value="right center">Right Center</option>
                                <option value="left bottom">Left Bottom</option>
                                <option value="center bottom">Center Bottom</option>
                                <option value="right bottom">Right Bottom</option>
                            </select></label>
                    </div>
                </div>
        </fieldset>

        <fieldset>
            <div class="row">
                <div class="form-group col-lg-3 col-md-6 col-sm-6">
                    <label>
                        Border:
                    </label>
                    <label class="select-customisized">
                        <select ng-model="fs.activeFormMessage.borderType" class="form-control">
                            <option value="none" selected="selected">None</option>
                            <option value="solid">Solid</option>
                            <option value="dashed">Dashed</option>
                            <option value="dotted">Dotted</option>
                        </select></label>
                </div>
                <div ng-if="fs.activeFormMessage.borderType !== 'none'">
                    <div class="form-group col-lg-3 col-md-6 col-sm-6">
                        <label>
                            Size:
                        </label>

                        <div class="input-group">
                            <input type="text" class='regular-text form-control'
                                   data-ng-model="fs.activeFormMessage.borderWidth" data-uf-input-spinner/>

                            <span class="input-group-addon">PX</span>
                        </div>
                    </div>
                    <div class="form-group col-lg-3 col-md-6 col-sm-6">
                        <label>
                            Color:
                        </label>
                        <input type="text" ng-farbtastic
                               class="form-control"
                               ng-model="fs.activeFormMessage.borderColor"/>
                    </div>
                    <div class="form-group col-lg-3 col-md-6 col-sm-6">
                        <label>
                            Radius:
                        </label>

                        <div class="input-group">
                            <input type="text" class='regular-text form-control'
                                   data-ng-model="fs.activeFormMessage.borderRadius" data-uf-input-spinner/>
                            <span class="input-group-addon">PX</span>
                        </div>
                    </div>
                </div>
            </div>
        </fieldset>

        <fieldset>
            <div class="row">
                <div class="form-group col-lg-3 col-md-6 col-sm-6">
                    <label>
                        Shadow:
                    </label>
                    <input type="text" ng-farbtastic
                           class="form-control"
                           ng-model="fs.activeFormMessage.boxShadowColor"/>
                </div>
                <div class="form-group col-lg-3 col-md-6 col-sm-6">
                    <label>
                        H:
                    </label>

                    <div class="input-group">
                        <input type="text" class='regular-text form-control'
                               data-ng-model="fs.activeFormMessage.boxShadowH" data-uf-input-spinner/>
                        <span class="input-group-addon">PX</span>
                    </div>
                </div>
                <div class="form-group col-lg-3 col-md-6 col-sm-6">
                    <label>
                        V:
                    </label>

                    <div class="input-group">
                        <input type="text" class='regular-text form-control'
                               data-ng-model="fs.activeFormMessage.boxShadowV" data-uf-input-spinner/>
                        <span class="input-group-addon">PX</span>
                    </div>
                </div>
                <div class="form-group col-lg-3 col-md-6 col-sm-6">
                    <label>
                        Blur:
                    </label>

                    <div class="input-group">
                        <input type="text" class='regular-text form-control'
                               data-ng-model="fs.activeFormMessage.boxShadowB" data-uf-input-spinner/>
                        <span class="input-group-addon">PX</span>
                    </div>
                </div>
            </div>
            <div class="row">
                <div class="form-group col-lg-3 col-md-6 col-sm-6 uf-inline-checkbox">
                    <label>
                        <input type="checkbox"
                               ng-model="fs.activeFormMessage.boxShadowInset" ng-true-value="'true'"
                               ng-false-value="'false'"
                            />
                        Inset
                    </label>
                </div>
            </div>
        </fieldset>

        <fieldset>
            <div class="row">
                <div class="form-group col-lg-6 col-md-8 col-sm-12">
                    <label>
                        Width:
                    </label>

                    <div class="input-group">
                        <input type="text" class='regular-text form-control'
                               data-ng-model="fs.activeFormMessage.width.value"
                               data-ng-model-options="{'debounce': 400}" data-uf-input-spinner
                               data-uf-input-max-percent="{{fs.activeFormMessage.width.unit}}" data-required="false"/>

                        <div class="input-group-btn div_units " id="titleWidthUnits" data-uib-dropdown>
                            <button type="button" class="btn btn-default dropdown-toggle" data-uib-dropdown-toggle>
                                {{fs.activeFormMessage.width.unit | uppercase}} <span class="caret"></span></button>
                            <ul class="dropdown-menu dropdown-menu-right" data-uib-dropdown-menu>
                                <li><a href="javascript:void(0)" onfocus="this.blur()"
                                       ng-click="fs.activeFormMessage.width.unit='px'">PX</a></li>
                                <li><a href="javascript:void(0)" onfocus="this.blur()"
                                       ng-click="fs.activeFormMessage.width.unit='%'">%</a></li>
                            </ul>
                        </div>
                    </div>
                </div>
            </div>

        </fieldset>

        <fieldset class="with-legend-line" ng-hide="fs.formState == 'loadmess'">
            <legend>
                Padding
            </legend>
            <label class="uf-checkbox-lock pull-right">
                <input type="checkbox" ng-model="fs.lockersState.messagePadding" ng-click="fs.lockChanges('messagePadding')"/>
                <i class="fa fa-lock"></i>
            </label>

            <div class="row">
                <div class="form-group col-lg-3 col-md-6 col-sm-6">
                    <label>
                        Top:
                    </label>

                    <div class="input-group">
                        <input type="text" class='regular-text form-control'
                               data-ng-model="fs.activeFormMessage.paddingTop" data-uf-input-spinner/>
                        <span class="input-group-addon">PX</span>
                    </div>
                </div>
                <div class="form-group col-lg-3 col-md-6 col-sm-6">
                    <label>
                        Right:
                    </label>

                    <div class="input-group">
                        <input type="text" class='regular-text form-control'
                               data-ng-model="fs.activeFormMessage.paddingRight" data-uf-input-spinner/>
                        <span class="input-group-addon">PX</span>
                    </div>
                </div>
                <div class="form-group col-lg-3 col-md-6 col-sm-6">
                    <label>
                        Bottom:
                    </label>

                    <div class="input-group">
                        <input type="text" class='regular-text form-control'
                               data-ng-model="fs.activeFormMessage.paddingBottom" data-uf-input-spinner/>
                        <span class="input-group-addon">PX</span>
                    </div>
                </div>
                <div class="form-group col-lg-3 col-md-6 col-sm-6">
                    <label>
                        Left:
                    </label>

                    <div class="input-group">
                        <input type="text" class='regular-text form-control'
                               data-ng-model="fs.activeFormMessage.paddingLeft" data-uf-input-spinner/>
                        <span class="input-group-addon">PX</span>
                    </div>
                </div>
            </div>
        </fieldset>

        <fieldset class="with-legend-line" ng-hide="fs.formState == 'loadmess'">
            <legend>
                Margin
            </legend>
            <label class="uf-checkbox-lock pull-right">
                <input type="checkbox" ng-model="fs.lockersState.messageMargin" ng-click="fs.lockChanges('messageMargin')"/>
                <i class="fa fa-lock"></i>
            </label>

            <div class="row">
                <div class="form-group col-lg-3 col-md-6 col-sm-6">
                    <label>
                        Top:
                    </label>

                    <div class="input-group">
                        <input type="text" class='regular-text form-control'
                               data-ng-model="fs.activeFormMessage.marginTop" data-uf-input-spinner/>
                        <span class="input-group-addon">PX</span>
                    </div>
                </div>
                <div class="form-group col-lg-3 col-md-6 col-sm-6">
                    <label>
                        Right:
                    </label>

                    <div class="input-group">
                        <input type="text" class='regular-text form-control'
                               data-ng-model="fs.activeFormMessage.marginRight" data-uf-input-spinner/>
                        <span class="input-group-addon">PX</span>
                    </div>
                </div>
                <div class="form-group col-lg-3 col-md-6 col-sm-6">
                    <label>
                        Bottom:
                    </label>

                    <div class="input-group">
                        <input type="text" class='regular-text form-control'
                               data-ng-model="fs.activeFormMessage.marginBottom" data-uf-input-spinner/>
                        <span class="input-group-addon">PX</span>
                    </div>
                </div>
                <div class="form-group col-lg-3 col-md-6 col-sm-6">
                    <label>
                        Left:
                    </label>

                    <div class="input-group">
                        <input type="text" class='regular-text form-control'
                               data-ng-model="fs.activeFormMessage.marginLeft" data-uf-input-spinner/>

                        <span class="input-group-addon">PX</span>
                    </div>
                </div>
            </div>
        </fieldset>

        <fieldset>
            <div class="row">
                <div class="form-group col-lg-6 col-md-8 col-sm-12">
                    <label>
                        Align:
                    </label>
                    <label class="select-customisized">
                        <select ng-model="fs.activeFormMessage.textAlign" class=" form-control">
                            <option value="inherit" selected="selected">System default</option>
                            <option value="left">Left</option>
                            <option value="center">Center</option>
                            <option value="right">Right</option>
                        </select></label>
                </div>
            </div>
        </fieldset>
    </div>
</uib-accordion-group>