<?php

/**
 * @package Unite Forms for Joomla 1.7-3.5
 * @author UniteCMS.net
 * @copyright (C) 2014 Unite CMS, All Rights Reserved.
 * @license GNU/GPLv3 http://www.gnu.org/licenses/gpl-3.0.html
 * */

defined('_JEXEC') or die;


$operations = new UniteFormsOperations();

$formID = UniteFunctionsForms::getGetVar("id");
$form = new UniteFormsForm();
$form->initByID($formID);

$formID = $form->getID();
$formTitle = $form->getTitle();

//load params
$arrValues = $form->getParams();
$params = $operations->getCombinedSettingsForm($arrValues);
$arrFields = $form->getArrFields();

//make output:
$output = new UniteFormsOutput();
$output->init($formID, $params, $arrFields);

$params = $output->getParams();

$jsonForm = json_encode(array("id" => $formID, "title" => $formTitle, "isDemoMode"=>$this->isDemoMode));
?>

<script>
    var form = <?php echo $jsonForm?>;
</script>

<div class="uf-visual-columns-wrap"  ng-controller="formPreviewCtrl as fp">
    <div class="uf-left-settings-area uf-preview-left-col bs-wrapper" ng-class="{'col-hidden': !fp.showLeftCol}">
        <a href="javascript:void(0)" ng-click="fp.toggleLeftCol()" class="uf-toggle-left-col">
            <i class="fa" ng-class="{'fa-chevron-left': fp.showLeftCol, 'fa-chevron-right': !fp.showLeftCol}"></i>
        </a>
        <div class="uf-col-inner-content">
            <div class="uf-editable-form-title">
                <span>{{fp.formTitle}}</span>
            </div>
            <div class="uf-preview-settings">
                <div class="row">
                    <div class="col-sm-12">
                        <h4>Preview Width:</h4>
                        <ul class="uf-preview-device-wrap">
                            <li ng-repeat="device in fp.previewDevices"
                                ng-class="{active: device._active}"
                                ng-click="fp.setActive(device, fp.previewDevices)">
                                <i class="fa fa-{{device.icon}}"></i>
                            </li>
                        </ul>
                    </div>
                </div>
                <div class="row">
                    <div class="col-sm-12">
                        <h4>Preview Background:</h4>
                        <ul class="uf-preview-bg-wrap">
                            <li ng-repeat="bg in fp.previewBg"
                                ng-class="{active: bg._active}"
                                ng-click="fp.setActive(bg, fp.previewBg)"
                                ng-style="{color: bg.color, backgroundImage: bg.img === false ? 'none' : null}">
                            </li>
                        </ul>
                    </div>
                </div>
            </div>
            <div class="uf-version-text">Version: <?php echo UF_VERSION ?></div>
        </div>
    </div>
    <div class="uf-right-settings-area" ng-class="{'uf-left-col-hidden': !fp.showLeftCol}">
        <div class="bs-wrapper top-menu-wrapper clearfix" ng-controller="formNavigationCtrl as fn">
            <ul class="nav nav-tabs pull-left">
                <li ng-class="{active: tab.active}" ng-repeat="tab in fn.tabs">
                    <a ng-href="{{tab.url}}">{{tab.title}}</a>
                </li>
            </ul>
            
            <div class="bs-wrapper uf-top-panel-btns">
            
           <?php if ($this->isDemoMode == true):?>
                 <a class="btn btn-success" href="<?php echo $this->linkBuyNow ?>">Buy Now</a>
            <?php else: ?>
                <a class="btn btn-default" href="<?php echo JRoute::_('index.php?option=com_uniteform&view=forms') ?>">Close</a>
            <?php endif?>
            </div>
            
        </div>
        <div class="uf-form-preview-wrapper" ng-style="fp.setFormPreviewStyles()">
            <?php $output->outputForm(); ?>
        </div>
    </div>
</div>