<?php

/**
 * @package Unite Forms for Joomla 1.7-3.5
 * @author UniteCMS.net
 * @copyright (C) 2014 Unite CMS, All Rights Reserved.
 * @license GNU/GPLv3 http://www.gnu.org/licenses/gpl-3.0.html
 * */

defined('_JEXEC') or die;


$formTitle = $this->form->getTitle();
$jsForm = json_encode(array("id" => $this->formID, "title" => $formTitle, "isDemoMode"=>$this->isDemoMode));

?>
    <script type="text/javascript">
        var g_jsonTemplatesFields = <?php echo $this->jsonTemplateFields?>;
        var g_jsonTemplatesStyles = <?php echo $this->jsonTemplateStyles?>;
        var g_jsonGeneralSettings = <?php echo $this->jsonGeneralSettings?>;
        var form = <?php echo $jsForm?>;
        var formOptions = <?php echo $this->jsonOptionsSettings ?>;
    </script>
    <div ng-controller="formMainCtrl as fm" ng-cloak>
        <div style="position: relative;">
            <div id="viewWrapper" class="uf-main-settings-area clearfix uf-visual-columns-wrap"
                 ng-controller="formSettingsCtrl as fs">
                <div class="bs-wrapper uf-left-settings-area">
                    <div class="uf-editable-form-title">
                        <form name="fm.formTitleForm">
                            <input type="text" ng-model="fm.formTitle" ng-blur="fm.saveTitle()"/>
                        </form>
                    </div>
                    <div class="uf-settings-block">
                        <div ng-show="activeTab.id === 'addElements' && !fs.activeElement"
                             class="elements-panel ng-hide">
                            <fieldset ng-repeat="block in fs.availableElements">
                                <legend ng-bind="block.title"></legend>
                                <div ui-tree="fs.newElementsDragEvents" data-max-depth="1"
                                     data-clone-enabled="true" data-ui-tree-config="fs.dndConfig"
                                     data-nodrop-enabled="true" data-drag-delay="150">
                                    <ul class="row" ui-tree-nodes="" ng-model="block.elements">
                                        <li ng-repeat="newEl in block.elements" ui-tree-node
                                            class="col-sm-6 new-el-btn-wrap">
                                            <a href="javascript:void(0)" onfocus="this.blur()" ng-attr-data-nodrag="{{newEl.disabled()}}"
                                               ng-disabled="newEl.disabled()" ondragstart="return false;"
                                               class="btn btn-small btn-default new-el-btn btn-block text-left"
                                               ng-click="!newEl.disabled() && fs.addEl[newEl.type]()" ng-bind="newEl.title"></a>
                                        </li>
                                    </ul>
                                </div>
                            </fieldset>
                        </div>
                        <div ng-show="activeTab.id === 'formStyle' && !fs.activeElement" class="settings-panel ng-hide">
                            <?php require "form_styles.php" ?>
                        </div>
                        <div ng-show="activeTab.id === 'settings' && !fs.activeElement" class="option-form-wrap ng-hide">
                            <?php require "form_settings.php" ?>
                        </div>
                        <div ng-if="fs.activeElement" ng-include="fs.selectedElTemplate()"></div>
                    </div>
                </div>

                <div class="uf-right-settings-area">
                    <div class="bs-wrapper">
                        <div class="top-menu-wrapper clearfix" ng-controller="formNavigationCtrl as fn">
                            <ul class="nav nav-tabs pull-left">
                                <li ng-class="{active: tab.active}" ng-repeat="tab in fn.tabs | filter:fn.isAvailableInDemo">
                                    <a href="javascript:void(0)" onfocus="this.blur()" ng-click="fn.go(tab)" ng-bind="tab.title"></a>
                                </li>
                            </ul>
                            <div class="uf-top-panel-btns" style="position: relative;">
                                <?php if ($this->isDemoMode == true) { ?>
                                    <a class="btn btn-success" href="<?php echo $this->linkBuyNow?>">Buy Now</a>
                                <?php } else { ?>
                                	<a class="btn btn-default" ng-href="{{fs.ufFormActionsUrls.formsView}}">Close</a>
                                    <div class="btn-group" uib-dropdown is-open="status.isopen">
                                        <button id="single-button" type="button" class="btn btn-default" uib-dropdown-toggle>
                                            More <span class="caret"></span>
                                        </button>
                                        <ul class="uib-dropdown-menu" role="menu" aria-labelledby="single-button">
                                            <li role="menuitem" ><a href="javascript:void(0)" ng-click="fm.saveTemplate()">Save Template</a></li>
                                            <li role="menuitem"><a href="javascript:void(0)" ng-click="fs.deleteForm()">Delete</a></li>
                                            <li role="menuitem"><a href="javascript:void(0)" ng-click="fs.exportForm()">Export Form</a></li>
                                            <li role="menuitem"><a href="javascript:void(0)" ng-click="fs.importForm()">Import Form</a></li>
                                        </ul>
                                    </div>
                                    <button class="btn btn-info" ng-click="fm.saveForm()">Save</button>
                                <?php } ?>
                            </div>
                        </div>

                        <uib-alert type="danger" ng-if="fm.emptyRequiredFields.length > 0" ng-cloak>
                            <p>Can't perform action. These fields are mandatory:</p>
                            <h4>
                                <span class="label label-default" style="margin-right: 5px;"
                                      ng-repeat="f in fm.emptyRequiredFields">{{f.text}}</span>
                            </h4>
                        </uib-alert>
                    </div>
                    
                    <div id="uf-form-settings-preview" class="uf-main">
                        <form uf-visual-form="fs.hideActiveElementSettings()" action="" class="uf-form"
                              uf-visual-form-styles="fs.activeFormStyles"
                              ng-style="fs.renderFormStyle()" ng-if="!fs.loading" dir="{{fs.activeFormStyles.formDirection}}"
                              uf-resize-directions="e" uf-resize="{{fs.showFormResize}}">
                            <div ng-if="fs.formState !== 'succmess'">
                                <div ui-tree="fs.formElementsDragEvents" data-max-depth="1"
                                     data-ui-tree-config="fs.dndConfig"
                                     data-empty-placeholder-enabled="true" data-clone-enabled="false">
                                    <ul ui-tree-nodes="" ng-model="fs.activeFormElements.fields" id="dropArea"
                                        class="uf-form-elements-list form-elements-parent uf-main">
                                        <li ng-repeat="el in fs.activeFormElements.fields"
                                            class="form-row uf-field-wrapper"
                                            ui-tree-node ng-class="{active: el._active}">
                                            <div ui-tree-handle>
                                                <div uf-element-proxy="{{el.type}}" class="field-details"
                                                     active-form-styles="fs.activeFormStyles"
                                                     element-actions="fs.elementActions"
                                                     default-styles="fs.defaultElValues" ng-model="el"></div>
                                            </div>
                                        </li>
                                    </ul>
                                </div>
                                <div id="buttonArea"
                                     ng-if="fs.activeFormElements.buttons[0] && fs.formState !== 'loadmess'">
                                    <div uf-element-proxy="button" active-form-styles="fs.activeFormStyles"
                                         element-actions="fs.elementActions"
                                         default-styles="{'button': fs.activeFormStyles.sendButton}"
                                         ng-model="fs.activeFormElements.buttons[0]"></div>
                                </div>
                            </div>
                            <div id="messArea">
                                <ul class="uf-form-elements-list form-elements-parent uf-main">
                                    <li class="form-row field-details" ng-repeat="messtype in fs.formMessagesTypes"
                                        ng-show="fs.formState == messtype">
                                        <div uf-element-proxy="message" element-actions="fs.elementActions"
                                             ng-model="fs.activeFormStyles[messtype]"></div>
                                    </li>
                                </ul>
                            </div>
                        </form>
                        <div class="loader big" ng-show="fs.loading"></div>
                    </div>
                </div>
            </div>
        </div>
        <div class="bs-wrapper">
            <uib-alert data-dismiss-on-timeout="5000" ng-repeat="alert in fm.alerts" type="{{alert.type}}"
                       close="fm.closeAlert($index)" class="uf-alerts">
                <div ng-bind-html="alert.msg"></div>
            </uib-alert>
        </div>
        <div id="colorpicker"></div>
    </div>
<?php $this->o->drawAfterBody() ?>