<?php
/**
 * @package     Joomla.Module
 * @subpackage  mod_ivm_gmap_location
 * @link        http://www.kreativan.net
 * @copyright   Ivan Milincic - www.kreativan.net. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

// No direct access
defined('_JEXEC') or die;

?>

<?php

    // Deafault Location
    $first_marker_array     = $markers_array[0];
    $default_title          = $first_marker_array[0];
    $default_location       = $first_marker_array[1];
    $default_info           = $first_marker_array[2];
    // remove new lines (enter)
    $default_info           = trim(preg_replace('/\s+/', ' ', $default_info));

    // remove new lines and convert it to <br />
	$default_info = preg_replace('~[\r\n]+~', ' <br />', $default_info);
	
	if($params->get('auto_links') ==  "1") {
		$url = '~(?:(https?)://([^\s<]+)|(www\.[^\s<]+?\.[^\s<]+))(?<![\.,:])~i'; 
		$default_info = preg_replace($url, '<a href="$0" target="_blank" title="$0">$0</a>', $default_info);
	}

    // Info Window Width
    $info_window_width          = $params->get('info_window_width');
	

?>

<script>

function initialize() {
    var map;
    var bounds = new google.maps.LatLngBounds();
    var myLatlng = new google.maps.LatLng(<?php echo $default_location;?>);
    var mapOptions = {
        center: myLatlng,
        draggable: <?php echo $params->get('draggable');?>,
        mapTypeId:google.maps.MapTypeId.<?php echo $params->get('map_type');?>,
        panControl:<?php echo $params->get('pan');?>,
        zoomControlOptions: {
            style:google.maps.ZoomControlStyle.<?php echo $params->get('zoom_options');?>
        },
        mapTypeControl:<?php echo $params->get('map_type_control');?>,
        scaleControl:false,
        streetViewControl:<?php echo $params->get('street_view_control');?>,
        overviewMapControl:<?php echo $params->get('overview_control');?>,
        rotateControl:false,
        scrollwheel:<?php echo $params->get('scrollwheel');?>,
        zoom: <?php echo $params->get('zoom');?>
    };

    // Display a map on the page
    map = new google.maps.Map(document.getElementById("ivm-gmap-<?php echo $module_id; ?>"), mapOptions);
    map.setTilt(45);

    <?php include '_map_styles.php';?>

    // Multiple Markers
    var markers = [
        ['<?php echo $default_title;?>', <?php echo $default_location;?>],
        <?php foreach($markers_array as $marker) :?>
        <?php
            //$marker_title = str_replace("'","","$marker[0]");
            $marker_title = $marker[0];
            //$marker_title = preg_replace('/[^A-Za-z0-9\-]/', '', $marker_title); // Removes special chars.
        ?>
        ['<?php echo $marker_title;?>', <?php echo $marker[1];?>],
        <?php endforeach;?>
        // last marker
        ['', '']
    ];

    // Info Window Content
    var infoWindowContent = [
        ['<div class="ivm-info-window" style="width:<?php echo $info_window_width;?>;overflow:hidden;">'+
        '<h4><?php echo $default_title; ?></h4>'+
        '<p>'+
        '<?php echo $default_info;?>'+
        '</p>' +
        '</div>'
        ],
		<?php $i = 0; ?>
        <?php foreach($markers_array as $info_window) :?>

            <?php

                $title          = ($info_window[0]) ? $info_window[0] : '' ;
                $coordinates    = ($info_window[1]) ? $info_window[1] : '' ;
                $info           = $info_window[2];

                // $title_id       = preg_replace("/[^a-zA-Z0-9]/", "", $title);
				// arabic
				$title_id = "title_id_" . $i++;

                $title          = str_replace("'","","$title");

                // remove new lines and convert it to <br />
				$info = preg_replace('~[\r\n]+~', '<br />', $info);
				
				if($params->get('auto_links') ==  "1") {
					$url = '~(?:(https?)://([^\s<]+)|(www\.[^\s<]+?\.[^\s<]+))(?<![\.,:])~i'; 
					$info = preg_replace($url, '<a href="$0" target="_blank" title="$0">$0</a>', $info);
				}
				

            ?>

        ['<div class="ivm-info-window" style="clear:both;width:<?php echo $info_window_width;?>;overflow:hidden;">'+
        '<h4><?php echo $title; ?></h4>'+
        '<p>'+
         '<?php echo $info;?>'+
        '</p>' +
         '</div>'
        ],
        <?php endforeach;?>
        ['']
    ];

    <?php if($params->get('show_info_window') == '1'):?>
    // Display multiple markers on a map
    var infoWindow = new google.maps.InfoWindow(), marker, i;
    <?php endif;?>

    // Loop through our array of markers & place each one on the map
    for( i = 0; i < markers.length; i++ ) {
        var markerImage = '<?php echo JURI::root( true ).'/'.$params->get('marker_icon');?>';
        var position = new google.maps.LatLng(markers[i][1], markers[i][2]);
        bounds.extend(position);
        marker = new google.maps.Marker({
            position: position,
            map: map,
            <?php if($params->get('marker_icon')):?>icon: markerImage,<?php endif;?>
            title: markers[i][0]
        });

        // Allow each marker to have an info window
        google.maps.event.addListener(marker, 'click', (function(marker, i) {
            return function() {
                infoWindow.setContent(infoWindowContent[i][0]);
                infoWindow.open(map, marker);
            }
        })(marker, i));

    }

    // map navigation markers & locations
    <?php if($params->get('navigation') == 1) :?>
        // Locations
		<?php $i = 0; ?>
        <?php foreach($markers_array as $id) :?>

            <?php
                $title          = ($id[0]) ? $id[0] : '' ;
                $coordinates    = ($id[1]) ? $id[1] : '' ;
                //$title_id       = preg_replace("/[^a-zA-Z0-9]/", "", $title);
				// arabic letters fix
				$title_id = "title_id_" . $i++;
            ?>

        var <?php echo $title_id;?> = new google.maps.LatLng(<?php echo $coordinates;?>);

        google.maps.event.addDomListener(document.getElementById("ivm-marker-<?php echo $title_id;?>-<?php echo $module_id; ?>"), "click", function() {
        map.setCenter(<?php echo $title_id;?>);
        });

        <?php endforeach;?>
    <?php endif;?>

}

// load map
google.maps.event.addDomListener(window, 'load', initialize);

</script>
