<?php
/**
 * @package     Joomla.Module
 * @subpackage  mod_ivm_gmap_location
 * @link        http://www.kreativan.net
 * @copyright   Ivan Milincic - www.kreativan.net. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

 include '_array.php';

// No direct access
defined('_JEXEC') or die;

$id = 0;
$id2 = 0;
$module_id = $module->id;

// map height
$map_height = $params->get('map_height');

// navigation
$mapNav         = $params->get('navigation');
$navSize        = $params->get('navigation_size');
$navPoz         = $params->get('navigation_position');
$navWidth       = $params->get('nav_size');

// Map Class
if($params->get('navigation') == 0) {
    $mapClass   = 'ivm-gmap-full';
    $navClass   = '';
}elseif($navPoz == 'left') {
    $mapClass   = 'ivm-gmap-right';
    $navClass   = ' ivm-gmap-nav-left';
}elseif($navPoz == 'right') {
    $mapClass   = 'ivm-gmap-left';
    $navClass   = ' ivm-gmap-nav-right';
}

// Nav Style
$navBG              = $params->get('nav_bg');
$navBorder          = $params->get('nav_border');
$navColor           = $params->get('nav_color');
$navPadding         = $params->get('nav_padding');
$navHoverBG         = $params->get('nav_hover_bg');
$navHoverColor      = $params->get('nav_hover_color');
$navScrollColor     = $params->get('nav_scroll_color');

// if navigation is on
if($params->get('navigation') == 1) {
    $navWidth = $navWidth;
}else {
    $navWidth = '0';
}

?>

<div class="ivm-gmap-location ivm-gmap-<?=$module_id?> ivm-clearfix" style="position:relative;">

<?php
    include '_map.php';
    include '_style_script.php';
?>

    <div class="ivm-gmap-container <?=$mapClass?>" style="width:100%;padding-<?=$navPoz?>:<?=$navWidth?>;">
        <div class="ivm-gmap" id="ivm-gmap-<?=$module_id?>" style="height:<?=$map_height;?>;"></div>
        <?php if( ($params->get('navigation') == 1) && ($params->get('responsive') == 1) ) :?>
            <a class="ivm-gmap-nav-button">
                <svg version="1.1" id="Capa_1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px"
                	 width="32px" height="32px" viewBox="0 0 466.583 466.582" style="enable-background:new 0 0 466.583 466.582;"
                	 xml:space="preserve" fill="#D83020">
                <g>
                	<path d="M233.292,0c-85.1,0-154.334,69.234-154.334,154.333c0,34.275,21.887,90.155,66.908,170.834
                		c31.846,57.063,63.168,104.643,64.484,106.64l22.942,34.775l22.941-34.774c1.317-1.998,32.641-49.577,64.483-106.64
                		c45.023-80.68,66.908-136.559,66.908-170.834C387.625,69.234,318.391,0,233.292,0z M233.292,233.291c-44.182,0-80-35.817-80-80
                		s35.818-80,80-80c44.182,0,80,35.817,80,80S277.473,233.291,233.292,233.291z"/>
                </g>
                </svg>
            </a>
        <?php endif;?>
    </div>

    <?php if($params->get('navigation') == 1) :?>
        <div class="ivm-gmap-navigation<?=$navClass?>" style="position:absolute;top:0;<?=$navPoz?>:0;width:<?=$navWidth?>;height:<?=$map_height?>;">
            <?php if( ($params->get('navigation') == 1) && ($params->get('responsive') == 1) ) :?>
                <a class="ivm-gmap-nav-button-close"></a>
            <?php endif;?>
            <div style="height:100%;">
				<?php $i = 0; ?>
                <?php foreach($markers_array as $nav) :?>
                    <?php
                            $title          = ($nav[0]) ? $nav[0] : '' ;
                            $info           = ($nav[2]) ? $nav[2] : '' ;
							$img			= ($nav[3]) ? $nav[3] : '' ;
							
							$img_height = $params->get("img_height");
							$img_height = !empty($img_height) ? $img_height : "60px";

                            //$title_id       = preg_replace("/[^a-zA-Z0-9]/", "", $title);
							// arab id
							$title_id = "title_id_" . $i++;

                            // remove new lines (enter)
                            //$info           = trim(preg_replace('/\s+/', ' ', $info));
							
							// covert string to link
							if($params->get('auto_links') ==  "1") {
								$url = '~(?:(https?)://([^\s<]+)|(www\.[^\s<]+?\.[^\s<]+))(?<![\.,:])~i'; 
								$info = preg_replace($url, '<a href="$0" target="_blank" title="$0">$0</a>', $info);
							}
							
							// new lines
							$info = nl2br($info);
                    ?>

                    <div class="ivm-map-nav-item" id="ivm-marker-<?=$title_id?>-<?=$module_id?>">
                        <div style="padding:<?=$navPadding?>;">
							<?php if(!empty($img)):?>
								<div style="margin-bottom:10px;">
								    <img src="<?= $img ?>" style="height:<?= $img_height ?>;" />
								</div>
							<?php endif;?>	
                            <h4 style="color:<?=$navColor?>;"><?= $title;?></h4>
                            <p style="opacity:0.8;">
                                <?= $info;?>
                            </p>
                        </div>
                    </div>
                <?php endforeach;?>
            </div>
        </div>
    <?php endif;?>

</div>
