<?php
/**
 * @package		Joomla.Plugin
 * @subpackage	Content.loadmodule
 * @copyright	Copyright (C) 2005 - 2014 Open Source Matters, Inc. All rights reserved.
 * @license		GNU General Public License version 2 or later; see LICENSE.txt
 */

// no direct access
defined('_JEXEC') or die;

class plgContentUniteform extends JPlugin{

	
	/**
	 * get form output html
	 */
	private function getFormOutput($formID){

		if(empty($formID))
			UniteFunctionsUG::throwError("form alias not found");
		
		ob_start();
		HelperUF::outputForm($formID, "alias");
		$content = ob_get_contents();
		ob_end_clean();
		
		return($content);
	}
	
	
	/**
	 * Plugin that loads module positions within content
	 *
	 * @param	string	The context of the content being passed to the plugin.
	 * @param	object	The article object.  Note $article->text is also available
	 * @param	object	The article params
	 * @param	int		The 'page' number
	 */
	public function onContentPrepare($context, &$article, &$params, $page = 0){
		
		
		// Don't run this plugin when the content is being indexed
		if ($context == 'com_finder.indexer')
			return true;
		
	
		if (strpos($article->text, 'uniteforms') === false)
			return true;
		
		$regex = '/{uniteforms\s+(.*?)}/i';
		preg_match_all($regex, $article->text, $arrMatches, PREG_SET_ORDER);
		
		//print_r($article->text);exit();
		
		if(empty($arrMatches))
			return(true);
		
		//require form files.
		$pathIncludes = JPATH_ADMINISTRATOR . "/components/com_uniteform/includes.php";
		require_once $pathIncludes;
				
		
		foreach($arrMatches as $match){
			if(!isset($match[1]))
				continue;

			$arguments = $match[1];
			
			$keywords = preg_split("/\s+/", $arguments);			
			$formID = $keywords[0];
			
			$catID = null;
			if(count($keywords) > 1){
				$strcat = $keywords[1];
				$strcat = str_replace("catid=", "", $strcat);
				$strcat = str_replace("catid =", "", $strcat);
				$strcat = str_replace("catid = ", "", $strcat);
				$catID = trim($strcat);
			}
									
			try{
			
				$output = $this->getFormOutput($formID);
				
			}catch(Exception $e){
				$message = "Unite Form Error: ".$e->getMessage();
				$output = HelperUF::getErrorMessageHtml($message);
			}
			
			//replace only first occurance
			$article->text = $article->text = preg_replace("|$match[0]|", addcslashes($output, '\\$'), $article->text, 1);
			
		}
						
		
	}
}
