<?php
/**
 * @package   plg_addcookielaw
 * @author    Addaptive <info@addaptive.com>
 * @copyright Copyright (C)2015 Addaptive. All rights reserved.
 * @license   GNU General Public License, version 2 or later; see LICENSE.txt
 */

defined('_JEXEC') or die;

require_once __DIR__ . '/libraries/parse_attrs.php';

/**
 * Class PlgSystemAddCookieLaw
 */
class PlgSystemAddCookieLaw extends JPlugin
{
	/**
	 * @var bool
	 */
	protected $autoloadLanguage = true;

	/**
	 * @var string
	 */
	protected $layoutOutput;

	/**
	 * Render the layout before the rendering of the page, to allow theme to add custom scripts and styles.
	 * Add the needed cookie bar assets.
	 *
	 * @throws Exception
	 */
	public function onBeforeCompileHead()
	{
		if (JFactory::getApplication()->isAdmin())
		{
			return;
		}

		// Save the scripts before render the layout.
		$cookie_policy_itemid  = $this->params->get('policy_page');

		// Prepare the data to pass to the layout
		$displayData = array(
			'bar_text'      => JText::_($this->params->get('bar_text', 'PLG_ADDCOOKIELAW_TEXT_DEFAULT')),
			'consent_label' => $this->params->get('consent_label', JText::_('PLG_ADDCOOKIELAW_CONSENT_LABEL_DEFAULT')),
			'cookie_mode'   => $this->params->get('cookie_mode', 'informational_only'),
			'policy_label'  => $this->params->get('policy_label', JText::_('PLG_ADDCOOKIELAW_POLICY_LABEL_DEFAULT')),
			'policy_url'    => $this->getMenuItemLink($cookie_policy_itemid),
			'refuse_label'  => $this->params->get('refuse_label', JText::_('PLG_ADDCOOKIELAW_REFUSE_LABEL_DEFAULT')),
		);

		// Prepend the cookie bar on top of the page.
		$this->layoutOutput = $this->render($displayData);

		// Add strictly needed styles and scripts
		JHtml::script('plugins/system/addcookielaw/assets/js/main.js');
		JHtml::script('plugins/system/addcookielaw/assets/js/js.cookie.js');

		if ($this->params->get('style_base', true))
		{
			JHtml::stylesheet('plugins/system/addcookielaw/assets/css/base.css');
		}
	}

	/**
	 * Inject the cookie bar within the page.
	 *
	 * @throws Exception
	 */
	public function onAfterRender()
	{
		$app = JFactory::getApplication();

		// Don't add cookie bar on Joomla backend
		if ($app->isAdmin())
		{
			return;
		}

		// Prepend the cookie bar on top of the page.
		$page_body = preg_replace('/(<body[^>]*>)/', '$1' . $this->layoutOutput, $app->getBody());

		// Replace the original page body
		$app->setBody($page_body);
	}

	/**
	 * @param $data
	 *
	 * @return string
	 */
	protected function render($data)
	{
		$data = new Joomla\Registry\Registry($data);

		$layout_path = $this->getLayoutPath();
		$cookie_mode = $this->params->get('cookie_mode', 'informational_only');
		$layout_html = JLayoutHelper::render('default', $data, $layout_path);
		$position    = $this->params->get('bar_position', 'bottom');

		return '<div class="addcookielaw --' . $position . '" data-thumbprint="' .
		$this->params->get('thumbprint') . '" data-mode="' . $cookie_mode . '">' . $layout_html . '</div>';
	}

	/**
	 * Returns the correct path of the layout, checking the presence of a template override.
	 */
	protected function getLayoutPath()
	{
		$template      = JFactory::getApplication()->getTemplate();
		$override_path = JPATH_THEMES . '/' . $template . '/html/plg_addcookielaw';

		// Return template override if exists
		if (file_exists($override_path . '/default.php'))
		{
			return $override_path;
		}

		return __DIR__ . '/layouts';
	}

	/**
	 * Retrieve the routed link of a menu item.
	 *
	 * @param $item_id int
	 *
	 * @return mixed
	 * @throws Exception
	 */
	protected function getMenuItemLink($item_id)
	{
		$menu_item = JFactory::getApplication()->getMenu()->getItem($item_id);

		// Route internal links or return raw
		if (isset($menu_item->link))
		{
			// Route internal urls
			if (strpos($menu_item->link, 'index.php') !== false)
			{
				$url = new JUri($menu_item->link);
				$url->setVar('Itemid', $item_id);

				return JRoute::_($url);
			}

			return $menu_item->link;
		}

		return '';
	}
}
