<?php
/**
 * @package   plg_addcookielaw
 * @author    Addaptive <info@addaptive.com>
 * @copyright Copyright (C)2015 Addaptive. All rights reserved.
 * @license   GNU General Public License, version 2 or later; see LICENSE.txt
 */

defined('_JEXEC') or die;

JFormHelper::loadFieldClass('textarea');

/**
 * Class JFormFieldTrumbowyg
 *
 * A minimalistic editor to avoid using Joomla craps for little text portions.
 */
class JFormFieldTrumbowyg extends JFormFieldTextarea
{
	/**
	 * @var string
	 */
	protected $type = 'Trumbowyg';

	/**
	 * Method to get the field input markup.
	 *
	 * @return  string  The field input markup.
	 *
	 * @since   11.1
	 */
	protected function getInput()
	{
		JHtml::script('plugins/system/addcookielaw/assets/js/trumbowyg_button.js');
		JHtml::script('plugins/system/addcookielaw/forms/fields/trumbowyg/trumbowyg.js');
		JHtml::stylesheet('plugins/system/addcookielaw/forms/fields/trumbowyg/ui/trumbowyg.css');
		JHtml::stylesheet('plugins/system/addcookielaw/assets/css/trumbowyg_button.css');

		// Add editor class to textarea
		$this->class = 'trumbowyg';
		$this->value = JText::_($this->value);

		return parent::getInput();// . $this->getQuickLinks();
	}

	/**
	 * @return string
	 */
	protected function getQuickLinks()
	{
		return '<p class="trumbowyg-links" data-eid="' . $this->id . '">' . JText::_('PLG_ADDCOOKIELAW_ADD_LINK') . ': ' .
		'<a href="#" data-ins="POLICY">' . JText::_('PLG_ADDCOOKIELAW_COOKIE_POLICY_LINK') . '</a> | ' .
		'<a href="#" data-ins="CONSENT">' . JText::_('PLG_ADDCOOKIELAW_COOKIE_CONSENT_LINK') . '</a> | ' .
		'<a href="#" data-ins="DECLINE">' . JText::_('PLG_ADDCOOKIELAW_COOKIE_REFUSE_LINK') . '</a>' .
		'</p>';
	}

}