<?php
/**
 * @package   plg_addcookielaw
 * @author    Addaptive <info@addaptive.com>
 * @copyright Copyright (C)2015 Addaptive. All rights reserved.
 * @license   GNU General Public License, version 2 or later; see LICENSE.txt
 */

defined('_JEXEC') or die;

$button_classes = 'mdl-button mdl-js-button mdl-button--raised mdl-js-ripple-effect mdl-button--accent';

// Stylize the cookie bar in our classic material design
JHtml::stylesheet('plugins/system/addcookielaw/assets/css/default.css');
JHtml::script('plugins/system/addcookielaw/assets/js/material.js');
?>

<div class="addcookielaw__wrapper">
	<div class="addcookielaw__text">
		<?php echo $displayData->get('bar_text'); ?>
	</div>
	<div class="addcookielaw__actions">
		<a href="<?php echo $displayData->get('policy_url'); ?>" class="addcookielaw__button --policy <?php echo $button_classes; ?>">
			<?php echo $displayData->get('policy_label'); ?>
		</a>
		<?php if ($displayData->get('cookie_mode') == 'implied_consent'): ?>
			<a href="#" class="addcookielaw__button --refuse <?php echo $button_classes; ?>">
				<?php echo $displayData->get('refuse_label'); ?>
			</a>
		<?php endif; ?>
		<a class="addcookielaw__button --consent <?php echo $button_classes; ?>">
			<?php echo $displayData->get('consent_label'); ?>
		</a>
	</div>
</div>